package com.batch.android.di.providers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.BatchNotificationChannelsManager;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class BatchNotificationChannelsManagerProvider {
  @NonNull
  public static final BatchNotificationChannelsManager get() {
    BatchNotificationChannelsManager instance = DI.getInstance().getSingletonInstance(BatchNotificationChannelsManager.class);
    if (instance != null) {
      return instance;
    }
    instance = BatchNotificationChannelsManager.provide();
    DI.getInstance().addSingletonInstance(BatchNotificationChannelsManager.class, instance);
    return instance;
  }

  @Nullable
  public static final BatchNotificationChannelsManager getSingleton() {
    return DI.getInstance().getSingletonInstance(BatchNotificationChannelsManager.class);
  }
}
