package com.batch.android.di.providers;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.batch.android.core.ObjectUserPreferencesStorage;
import com.batch.android.di.DI;

/**
 * isSingleton = true
 */
public final class ObjectUserPreferencesStorageProvider {
  @NonNull
  public static final ObjectUserPreferencesStorage get(Context context) {
    ObjectUserPreferencesStorage instance = DI.getInstance().getSingletonInstance(ObjectUserPreferencesStorage.class);
    if (instance != null) {
      return instance;
    }
    instance = new ObjectUserPreferencesStorage(context);
    DI.getInstance().addSingletonInstance(ObjectUserPreferencesStorage.class, instance);
    return instance;
  }

  @Nullable
  public static final ObjectUserPreferencesStorage getSingleton() {
    return DI.getInstance().getSingletonInstance(ObjectUserPreferencesStorage.class);
  }
}
