/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.autogen;

import com.basistech.autogen.Template;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.python.core.PyCode;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class AutogenMojo
extends AbstractMojo {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private File outputDirectory;
    private List<Template> templates;
    private MavenProject project;
    private String language = "java";
    private PySystemState pySystemState = new PySystemState();

    public void execute() throws MojoExecutionException, MojoFailureException {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (this.project != null && this.outputDirectory != null && this.outputDirectory.exists()) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        for (Template template : this.templates) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("autogen.py");
            args.add("-t");
            if (!template.getCode().exists()) {
                throw new MojoExecutionException(String.format("Template %s does not exist.", template.getCode().getAbsolutePath()));
            }
            args.add(template.getCode().getAbsolutePath());
            args.add("-o");
            File outputDir = this.outputDirectory;
            if (template.getPackageName() != null) {
                String dirTail = template.getPackageName().replaceAll("\\.", "/");
                outputDir = new File(outputDir, dirTail);
            }
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            String outName = template.getCode().getName().replace(String.format(".%1s.tpl", this.language), String.format(".%1$s", this.language));
            File of = new File(outputDir, outName);
            args.add(of.getAbsolutePath());
            args.add(template.getData().getAbsolutePath());
            this.getLog().info((CharSequence)("Running: " + args));
            AutogenMojo.runAutogen(this.pySystemState, args.toArray(new String[args.size()]));
        }
    }

    static void runAutogen(PySystemState pySystemState, String[] args) {
        PyList argv = new PyList();
        if (args != null) {
            for (String arg : args) {
                argv.append((PyObject)new PyString(arg));
            }
        }
        pySystemState.argv = argv;
        PythonInterpreter pi = new PythonInterpreter((PyObject)new PyStringMap(), pySystemState);
        InputStreamReader genReader = new InputStreamReader(AutogenMojo.class.getResourceAsStream("/autogen.py"), UTF8);
        PyCode autogenCode = pi.compile((Reader)genReader);
        pi.exec((PyObject)autogenCode);
    }
}

