/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.StaticMethodMatcher;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;

public class DynamicDataSourceAnnotationAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private final Advice advice;
    private final Pointcut pointcut;
    private final Class<? extends Annotation> annotation;

    public DynamicDataSourceAnnotationAdvisor(@NonNull MethodInterceptor advice, @NonNull Class<? extends Annotation> annotation) {
        if (advice == null) {
            throw new NullPointerException("advice is marked non-null but is null");
        }
        if (annotation == null) {
            throw new NullPointerException("annotation is marked non-null but is null");
        }
        this.advice = advice;
        this.annotation = annotation;
        this.pointcut = this.buildPointcut();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.advice).setBeanFactory(beanFactory);
        }
    }

    private Pointcut buildPointcut() {
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(this.annotation, true);
        AnnotationMethodPoint mpc = new AnnotationMethodPoint(this.annotation);
        return new ComposablePointcut((Pointcut)cpc).union((Pointcut)mpc);
    }

    private static class AnnotationMethodPoint
    implements Pointcut {
        private final Class<? extends Annotation> annotationType;

        public AnnotationMethodPoint(Class<? extends Annotation> annotationType) {
            Assert.notNull(annotationType, (String)"Annotation type must not be null");
            this.annotationType = annotationType;
        }

        public ClassFilter getClassFilter() {
            return ClassFilter.TRUE;
        }

        public MethodMatcher getMethodMatcher() {
            return new AnnotationMethodMatcher(this.annotationType);
        }

        private static class AnnotationMethodMatcher
        extends StaticMethodMatcher {
            private final Class<? extends Annotation> annotationType;

            public AnnotationMethodMatcher(Class<? extends Annotation> annotationType) {
                this.annotationType = annotationType;
            }

            public boolean matches(Method method, Class<?> targetClass) {
                if (this.matchesMethod(method)) {
                    return true;
                }
                if (Proxy.isProxyClass(targetClass)) {
                    return false;
                }
                Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
                return specificMethod != method && this.matchesMethod(specificMethod);
            }

            private boolean matchesMethod(Method method) {
                return AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, this.annotationType);
            }
        }
    }
}

