/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.creator.druid.DruidConfig;
import com.baomidou.dynamic.datasource.toolkit.DsConfigUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DruidConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(DruidConfigUtil.class);
    private static final String FILTERS = "druid.filters";
    private static final String CONFIG_STR = "config";
    private static final String STAT_STR = "stat";
    private static final Map<String, PropertyDescriptor> CONFIG_DESCRIPTOR_MAP = DsConfigUtil.getPropertyDescriptorMap(DruidConfig.class);
    private static final Map<String, PropertyDescriptor> DATASOURCE_DESCRIPTOR_MAP = DsConfigUtil.getPropertyDescriptorMap(DruidDataSource.class);
    private static final Class<?> CLAZZ = DruidDataSource.class;

    public static Properties mergeConfig(DruidConfig g, @NonNull DruidConfig c) {
        Properties gConnectionProperties;
        String publicKey;
        boolean configFilterExist;
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        Properties properties = new Properties();
        for (Map.Entry<String, PropertyDescriptor> entry : CONFIG_DESCRIPTOR_MAP.entrySet()) {
            String key = entry.getKey();
            PropertyDescriptor descriptor = entry.getValue();
            Method readMethod = descriptor.getReadMethod();
            Class<?> returnType = readMethod.getReturnType();
            if (List.class.isAssignableFrom(returnType) || Set.class.isAssignableFrom(returnType) || Map.class.isAssignableFrom(returnType) || Properties.class.isAssignableFrom(returnType)) continue;
            try {
                Object gValue;
                Object cValue = readMethod.invoke((Object)c, new Object[0]);
                if (cValue != null) {
                    properties.setProperty("druid." + key, String.valueOf(cValue));
                    continue;
                }
                if (g == null || (gValue = readMethod.invoke((Object)g, new Object[0])) == null) continue;
                properties.setProperty("druid." + key, String.valueOf(gValue));
            }
            catch (Exception e) {
                log.warn("druid current could not set  [" + key + " ]", (Throwable)e);
            }
        }
        String filters = DruidConfigUtil.getValue(g, c, "filters");
        if (filters == null) {
            filters = STAT_STR;
        }
        boolean bl = configFilterExist = (publicKey = DruidConfigUtil.getValue(g, c, "publicKey")) != null && publicKey.length() > 0;
        if (publicKey != null && publicKey.length() > 0 && !filters.contains(CONFIG_STR)) {
            filters = filters + ",config";
        }
        properties.setProperty(FILTERS, filters);
        Properties connectProperties = new Properties();
        Properties cConnectionProperties = c.getConnectionProperties();
        if (g != null && (gConnectionProperties = g.getConnectionProperties()) != null) {
            connectProperties.putAll((Map<?, ?>)gConnectionProperties);
        }
        if (cConnectionProperties != null) {
            connectProperties.putAll((Map<?, ?>)cConnectionProperties);
        }
        if (configFilterExist) {
            connectProperties.setProperty("config.decrypt", Boolean.TRUE.toString());
            connectProperties.setProperty("config.decrypt.key", publicKey);
        }
        c.setConnectionProperties(connectProperties);
        return properties;
    }

    public static String getValue(DruidConfig g, @NonNull DruidConfig c, String field) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        PropertyDescriptor propertyDescriptor = CONFIG_DESCRIPTOR_MAP.get(field);
        if (propertyDescriptor == null) {
            return null;
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            return null;
        }
        try {
            Object value = method.invoke((Object)c, new Object[0]);
            if (value != null) {
                return String.valueOf(value);
            }
            if (g != null && (value = method.invoke((Object)g, new Object[0])) != null) {
                return String.valueOf(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setValue(DruidDataSource dataSource, String field, DruidConfig g, DruidConfig c) {
        PropertyDescriptor descriptor = DATASOURCE_DESCRIPTOR_MAP.get(field);
        if (descriptor == null) {
            log.warn("druid current not support [" + field + " ]");
            return;
        }
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null) {
            log.warn("druid current could not set  [" + field + " ]");
            return;
        }
        try {
            Method configReadMethod = CONFIG_DESCRIPTOR_MAP.get(field).getReadMethod();
            Object value = configReadMethod.invoke((Object)c, new Object[0]);
            if (value != null) {
                writeMethod.invoke((Object)dataSource, value);
                return;
            }
            if (g != null && (value = configReadMethod.invoke((Object)g, new Object[0])) != null) {
                writeMethod.invoke((Object)dataSource, value);
            }
        }
        catch (Exception e) {
            log.warn("druid current  set  [" + field + " ] error");
        }
    }
}

