/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothisk;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.iothisk.AbstractIotHiskBceClient;
import com.baidubce.services.iothisk.IotPkiManageConstants;
import com.baidubce.services.iothisk.model.BatchCreateClientCertRequest;
import com.baidubce.services.iothisk.model.BatchCreateClientCertResponse;
import com.baidubce.services.iothisk.model.CreateCertGroupRequest;
import com.baidubce.services.iothisk.model.CreateCertGroupResponse;
import com.baidubce.services.iothisk.model.CreateRootCACertRequest;
import com.baidubce.services.iothisk.model.CreateRootCACertResponse;
import com.baidubce.services.iothisk.model.CreateSubCertRequest;
import com.baidubce.services.iothisk.model.CreateSubCertResponse;
import com.baidubce.services.iothisk.model.DefaultIotPkiManageRequest;
import com.baidubce.services.iothisk.model.DefaultIotPkiManageResponse;
import com.baidubce.services.iothisk.model.DownloadCrlResponse;
import com.baidubce.services.iothisk.model.GetBatchCreateStatusResponse;
import com.baidubce.services.iothisk.model.GetCertGroupResponse;
import com.baidubce.services.iothisk.model.GetCertStatusRequest;
import com.baidubce.services.iothisk.model.GetCertStatusResponse;
import com.baidubce.services.iothisk.model.GetOcspResponse;
import com.baidubce.services.iothisk.model.GetRootCACertResponse;
import com.baidubce.services.iothisk.model.GetSubCertResponse;
import com.baidubce.services.iothisk.model.IotPkiManageResponse;
import com.baidubce.services.iothisk.model.QueryClientCertResponse;
import com.baidubce.services.iothisk.model.QueryServerCertResponse;
import com.baidubce.services.iothisk.model.RenewSubCertRequest;
import com.baidubce.services.iothisk.model.RenewSubCertResponse;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class IotPkiManageClient
extends AbstractIotHiskBceClient {
    public IotPkiManageClient(BceClientConfiguration config) {
        super(config.getEndpoint() == null ? config.withEndpoint("pkiiov.baidubce.com") : config, HANDLERS);
    }

    public CreateRootCACertResponse createRootCACert(CreateRootCACertRequest request, String clientToken) {
        Preconditions.checkNotNull((Object)request, (Object)"Request should not be null.");
        this.checkClientToken(clientToken);
        InternalRequest internalRequest = this.createIotPkiManageRequest(request, HttpMethodName.POST, "rootcert", new String[0]);
        internalRequest.addParameter("clientToken", clientToken);
        return this.invokeHttpClient(internalRequest, CreateRootCACertResponse.class);
    }

    public void deleteRootCACert(String certId) {
        this.checkCertId(certId);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.DELETE, "rootcert", certId);
        this.invokeHttpClient(internalRequest, DefaultIotPkiManageResponse.class);
    }

    public GetRootCACertResponse getRootCACert(String certId) {
        this.checkCertId(certId);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.GET, "rootcert", certId);
        return this.invokeHttpClient(internalRequest, GetRootCACertResponse.class);
    }

    public CreateCertGroupResponse createCertGroup(CreateCertGroupRequest request, String clientToken) {
        Preconditions.checkNotNull((Object)request, (Object)"Request should not be null.");
        this.checkClientToken(clientToken);
        InternalRequest internalRequest = this.createIotPkiManageRequest(request, HttpMethodName.POST, "certgroup", new String[0]);
        internalRequest.addParameter("clientToken", clientToken);
        return this.invokeHttpClient(internalRequest, CreateCertGroupResponse.class);
    }

    public void deleteCertGroup(String groupId) {
        this.checkCertId(groupId);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.DELETE, "certgroup", groupId);
        this.invokeHttpClient(internalRequest, DefaultIotPkiManageResponse.class);
    }

    public GetCertGroupResponse getCertGroup(String groupId) {
        this.checkCertId(groupId);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.GET, "certgroup", groupId);
        return this.invokeHttpClient(internalRequest, GetCertGroupResponse.class);
    }

    public CreateSubCertResponse createServerCert(CreateSubCertRequest request, String clientToken) {
        return this.createSubCert(request, clientToken, CertType.SERVER);
    }

    public void deleteServerCert(String serverCertId) {
        this.deleteSubCert(serverCertId, CertType.SERVER);
    }

    public GetSubCertResponse getServerCert(String serverCertId) {
        return this.getSubCert(serverCertId, CertType.SERVER);
    }

    public QueryServerCertResponse queryServerCerts(String rootCACertId, String groupId) {
        return this.querySubCerts(rootCACertId, groupId, CertType.SERVER, QueryServerCertResponse.class);
    }

    public RenewSubCertResponse renewServerCert(RenewSubCertRequest request, String serverCertId, String clientToken) {
        return this.renewSubCert(request, serverCertId, clientToken, CertType.SERVER);
    }

    public CreateSubCertResponse createClientCert(CreateSubCertRequest request, String clientToken) {
        return this.createSubCert(request, clientToken, CertType.CLIENT);
    }

    public void deleteClientCert(String clientCertId) {
        this.deleteSubCert(clientCertId, CertType.CLIENT);
    }

    public GetSubCertResponse getClientCert(String clientCertId) {
        return this.getSubCert(clientCertId, CertType.CLIENT);
    }

    public QueryClientCertResponse queryClientCerts(String rootCACertId, String groupId) {
        return this.querySubCerts(rootCACertId, groupId, CertType.CLIENT, QueryClientCertResponse.class);
    }

    public RenewSubCertResponse renewClientCert(RenewSubCertRequest request, String clientCertId, String clientToken) {
        return this.renewSubCert(request, clientCertId, clientToken, CertType.CLIENT);
    }

    public BatchCreateClientCertResponse batchCreateClientCert(BatchCreateClientCertRequest request, String clientToken) {
        Preconditions.checkNotNull((Object)request, (Object)"Request should not be null.");
        this.checkClientToken(clientToken);
        InternalRequest internalRequest = this.createIotPkiManageRequest(request, HttpMethodName.POST, "clientcert", "job");
        internalRequest.addParameter("clientToken", clientToken);
        return this.invokeHttpClient(internalRequest, BatchCreateClientCertResponse.class);
    }

    public GetBatchCreateStatusResponse getBatchCreateStatus(String jobId) {
        this.checkJobId(jobId);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.GET, "clientcert", "job", jobId);
        return this.invokeHttpClient(internalRequest, GetBatchCreateStatusResponse.class);
    }

    public String downloadClientCert(String clientCertId) {
        return this.downloadCert(clientCertId, CertType.CLIENT);
    }

    public String downloadServerCert(String serverCertId) {
        return this.downloadCert(serverCertId, CertType.SERVER);
    }

    public String downloadRootCert(String rootCertId) {
        return this.downloadCert(rootCertId, CertType.ROOT);
    }

    public Map<String, String> downloadBatchCreateCerts(String jobId) {
        this.checkJobId(jobId);
        GetBatchCreateStatusResponse response = this.getBatchCreateStatus(jobId);
        if (response.isSucceed() || response.isPartialSucceed()) {
            try {
                return this.unzipCert(IOUtils.toByteArray((URL)new URL(response.getDownloadUrl())));
            }
            catch (IOException e) {
                throw new RuntimeException("Download cert failed");
            }
        }
        return null;
    }

    public GetCertStatusResponse getCertStatus(GetCertStatusRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request should not be null.");
        InternalRequest internalRequest = this.createIotPkiManageRequest(request, HttpMethodName.PUT, "cert", "getstatus");
        return this.invokeHttpClient(internalRequest, GetCertStatusResponse.class);
    }

    public DownloadCrlResponse downloadCrl(String issuerDN) {
        this.checkIssuerDN(issuerDN);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.GET, "crl", new String[0]);
        internalRequest.setParameters(IotPkiManageConstants.CRL_PARAMS);
        internalRequest.addParameter("issuer", issuerDN);
        return this.invokeHttpClient(internalRequest, DownloadCrlResponse.class);
    }

    public GetOcspResponse getOcspResponse(byte[] ocspRequest) {
        Preconditions.checkNotNull((Object)ocspRequest, (Object)"Request should not be null.");
        String encodedOcspRequest = this.encodeOcspReqeust(ocspRequest);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.GET, "ocsp", encodedOcspRequest);
        return this.invokeHttpClient(internalRequest, GetOcspResponse.class);
    }

    private InternalRequest createIotPkiManageRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String subPath, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(Arrays.asList("v1", "pki", subPath));
        return this.createRequest(bceRequest, httpMethod, null, path, pathVariables);
    }

    private void checkClientToken(String clientToken) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)clientToken), (Object)"Client token can not be empty");
        Preconditions.checkArgument((StringUtils.length((CharSequence)clientToken) <= 64 ? 1 : 0) != 0, (Object)IotPkiManageConstants.TOO_LONG_CLIENT_TOKEN);
    }

    private void checkCertId(String certId) {
        Preconditions.checkArgument((StringUtils.length((CharSequence)certId) == 32 ? 1 : 0) != 0, (Object)"Invalid cert ID");
    }

    private void checkIssuerDN(String issuerDN) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)issuerDN), (Object)"Invalid issuer DN");
    }

    private void checkJobId(String jobId) {
        Preconditions.checkArgument((StringUtils.length((CharSequence)jobId) == 32 ? 1 : 0) != 0, (Object)"Invalid job ID");
    }

    private void checkAddressNotEmpty(List<String> address) {
        Preconditions.checkArgument((address != null && !address.isEmpty() ? 1 : 0) != 0, (Object)"Address should not be empty when created server cert.");
    }

    private CreateSubCertResponse createSubCert(CreateSubCertRequest request, String clientToken, CertType certType) {
        Preconditions.checkNotNull((Object)request, (Object)"Request should not be null.");
        this.checkClientToken(clientToken);
        if (certType == CertType.SERVER) {
            this.checkAddressNotEmpty(request.getAddress());
        }
        InternalRequest internalRequest = this.createIotPkiManageRequest(request, HttpMethodName.POST, this.getSubCertPathByCertType(certType), new String[0]);
        internalRequest.addParameter("clientToken", clientToken);
        return this.invokeHttpClient(internalRequest, CreateSubCertResponse.class);
    }

    private void deleteSubCert(String subCertId, CertType certType) {
        this.checkCertId(subCertId);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.DELETE, this.getSubCertPathByCertType(certType), subCertId);
        this.invokeHttpClient(internalRequest, DefaultIotPkiManageResponse.class);
    }

    private GetSubCertResponse getSubCert(String subCertId, CertType certType) {
        this.checkCertId(subCertId);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.GET, this.getSubCertPathByCertType(certType), subCertId);
        return this.invokeHttpClient(internalRequest, GetSubCertResponse.class);
    }

    private <T extends IotPkiManageResponse> T querySubCerts(String rootCACertId, String groupId, CertType certType, Class<T> responseClass) {
        Preconditions.checkArgument((rootCACertId != null || groupId != null ? 1 : 0) != 0);
        InternalRequest internalRequest = this.createIotPkiManageRequest(new DefaultIotPkiManageRequest(), HttpMethodName.GET, this.getSubCertPathByCertType(certType), "query");
        if (rootCACertId != null) {
            internalRequest.addParameter("rootCertId", rootCACertId);
        }
        if (groupId != null) {
            internalRequest.addParameter("groupId", groupId);
        }
        return (T)((IotPkiManageResponse)this.invokeHttpClient(internalRequest, responseClass));
    }

    private RenewSubCertResponse renewSubCert(RenewSubCertRequest request, String subCertId, String clientToken, CertType certType) {
        Preconditions.checkNotNull((Object)request, (Object)"Request should not be null.");
        this.checkCertId(subCertId);
        this.checkClientToken(clientToken);
        if (certType == CertType.SERVER) {
            this.checkAddressNotEmpty(request.getNewAddress());
        }
        InternalRequest internalRequest = this.createIotPkiManageRequest(request, HttpMethodName.PUT, this.getSubCertPathByCertType(certType), subCertId, "renew");
        internalRequest.addParameter("clientToken", clientToken);
        return this.invokeHttpClient(internalRequest, RenewSubCertResponse.class);
    }

    private String downloadCert(String certId, CertType certType) {
        this.checkCertId(certId);
        switch (certType) {
            case SERVER: 
            case CLIENT: {
                return this.downloadCert(this.getSubCert(certId, certType).getDownloadUrl());
            }
            case ROOT: {
                return this.downloadCert(this.getRootCACert(certId).getDownloadUrl());
            }
        }
        throw new RuntimeException("Invalid cert type");
    }

    private String downloadCert(String downloadUrl) {
        try {
            return IOUtils.toString((URL)new URL(downloadUrl));
        }
        catch (IOException e) {
            throw new RuntimeException("Download cert failed");
        }
    }

    private String getSubCertPathByCertType(CertType certType) {
        return certType == CertType.SERVER ? "servercert" : "clientcert";
    }

    private Map<String, String> unzipCert(byte[] certZip) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(certZip);
        ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
        HashMap<String, String> deviceIdCertMap = new HashMap<String, String>();
        ZipEntry entry = zipInputStream.getNextEntry();
        byte[] buffer = new byte[1024];
        while (entry != null) {
            int len;
            String name = entry.getName();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((len = zipInputStream.read(buffer)) > 0) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            zipInputStream.closeEntry();
            deviceIdCertMap.put(name, new String(byteArrayOutputStream.toByteArray()));
            byteArrayOutputStream.close();
            entry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return deviceIdCertMap;
    }

    private String encodeOcspReqeust(byte[] ocspRequest) {
        try {
            return URLEncoder.encode(Base64.encodeBase64String((byte[])ocspRequest), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid ocsp request");
        }
    }

    private static enum CertType {
        SERVER,
        CLIENT,
        ROOT;

    }
}

