/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos;

import com.baidubce.BceClientConfiguration;
import com.baidubce.Protocol;
import com.baidubce.Region;
import com.baidubce.auth.BceCredentials;
import com.baidubce.http.RetryPolicy;
import com.google.common.base.Preconditions;
import java.net.InetAddress;

public class BosClientConfiguration
extends BceClientConfiguration {
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 0x500000;
    private int streamBufferSize = 0x500000;
    private boolean cnameEnabled;

    public int getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public BosClientConfiguration() {
    }

    public BosClientConfiguration(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, null);
    }

    public BosClientConfiguration(BceClientConfiguration clientConfiguration, String bosEndpoint) {
        super(clientConfiguration, bosEndpoint);
    }

    public void setStreamBufferSize(int streamBufferSize) {
        Preconditions.checkArgument((streamBufferSize > 0 ? 1 : 0) != 0, (Object)"streamBufferSize should be positive.");
        this.streamBufferSize = streamBufferSize;
    }

    public BosClientConfiguration withStreamBufferSize(int streamBufferSize) {
        this.setStreamBufferSize(streamBufferSize);
        return this;
    }

    public boolean isCnameEnabled() {
        return this.cnameEnabled;
    }

    public void setCnameEnabled(boolean cnameEnabled) {
        this.cnameEnabled = cnameEnabled;
    }

    public BosClientConfiguration withCnameEnabled(boolean cnameEnabled) {
        this.setCnameEnabled(cnameEnabled);
        return this;
    }

    @Override
    public BosClientConfiguration withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    @Override
    public BosClientConfiguration withMaxConnections(int maxConnections) {
        this.setMaxConnections(maxConnections);
        return this;
    }

    @Override
    public BosClientConfiguration withUserAgent(String userAgent) {
        this.setUserAgent(userAgent);
        return this;
    }

    @Override
    public BosClientConfiguration withLocalAddress(InetAddress localAddress) {
        this.setLocalAddress(localAddress);
        return this;
    }

    @Override
    public BosClientConfiguration withProxyHost(String proxyHost) {
        this.setProxyHost(proxyHost);
        return this;
    }

    @Override
    public BosClientConfiguration withProxyPort(int proxyPort) {
        this.setProxyPort(proxyPort);
        return this;
    }

    @Override
    public BosClientConfiguration withProxyUsername(String proxyUsername) {
        this.setProxyUsername(proxyUsername);
        return this;
    }

    @Override
    public BosClientConfiguration withProxyPassword(String proxyPassword) {
        this.setProxyPassword(proxyPassword);
        return this;
    }

    @Override
    public BosClientConfiguration withProxyDomain(String proxyDomain) {
        this.setProxyDomain(proxyDomain);
        return this;
    }

    @Override
    public BosClientConfiguration withProxyWorkstation(String proxyWorkstation) {
        this.setProxyWorkstation(proxyWorkstation);
        return this;
    }

    @Override
    public BosClientConfiguration withRetryPolicy(RetryPolicy retryPolicy) {
        this.setRetryPolicy(retryPolicy);
        return this;
    }

    @Override
    public BosClientConfiguration withSocketTimeoutInMillis(int socketTimeoutInMillis) {
        this.setSocketTimeoutInMillis(socketTimeoutInMillis);
        return this;
    }

    @Override
    public BosClientConfiguration withConnectionTimeoutInMillis(int connectionTimeoutInMillis) {
        this.setConnectionTimeoutInMillis(connectionTimeoutInMillis);
        return this;
    }

    @Override
    public BosClientConfiguration withSocketBufferSizeInBytes(int socketBufferSizeInBytes) {
        this.setSocketBufferSizeInBytes(socketBufferSizeInBytes);
        return this;
    }

    @Override
    public BceClientConfiguration withProxyPreemptiveAuthenticationEnabled(boolean proxyPreemptiveAuthenticationEnabled) {
        this.setProxyPreemptiveAuthenticationEnabled(proxyPreemptiveAuthenticationEnabled);
        return this;
    }

    @Override
    public BosClientConfiguration withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    @Override
    public BosClientConfiguration withRegion(Region region) {
        this.setRegion(region);
        return this;
    }

    @Override
    public BosClientConfiguration withCredentials(BceCredentials credentials) {
        this.setCredentials(credentials);
        return this;
    }
}

