/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.sts.example;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.auth.DefaultBceSessionCredentials;
import com.baidubce.services.sts.StsClient;
import com.baidubce.services.sts.model.GetSessionTokenRequest;
import com.baidubce.services.sts.model.GetSessionTokenResponse;

public class StsExample {
    private static final String ENDPOINT = "http://sts.bj.baidubce.com";
    private static final String ACCESS_KEY_ID = "your accesskey id";
    private static final String SECRET_ACCESS_KEY = "your secret accesskey";

    public static void main(String[] args) {
        DefaultBceCredentials credentials = new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY);
        StsClient client = new StsClient(new BceClientConfiguration().withEndpoint(ENDPOINT).withCredentials(credentials));
        GetSessionTokenResponse response = client.getSessionToken(new GetSessionTokenRequest());
        DefaultBceSessionCredentials tempCredentials = new DefaultBceSessionCredentials(response.getCredentials().getAccessKeyId(), response.getCredentials().getSecretAccessKey(), response.getCredentials().getSessionToken());
        System.out.println("==================================");
        System.out.println("GetSessionToken result:");
        System.out.println("    accessKeyId:  " + response.getCredentials().getAccessKeyId());
        System.out.println("    secretAccessKey:  " + response.getCredentials().getSecretAccessKey());
        System.out.println("    securityToken:  " + response.getCredentials().getSessionToken());
        System.out.println("    expiresAt:  " + response.getCredentials().getExpiration().toString());
        System.out.println("==================================");
    }
}

