/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.thread;

import com.baidu.brpc.client.channel.BootstrapManager;
import com.baidu.brpc.thread.BrpcThreadPoolManager;
import com.baidu.brpc.thread.ClientHealthCheckTimerInstance;
import com.baidu.brpc.thread.ServerAcceptorThreadPoolInstance;
import com.baidu.brpc.thread.ServerIoThreadPoolInstance;
import com.baidu.brpc.thread.ServerWorkThreadPoolInstance;
import com.baidu.brpc.thread.TimerInstance;
import com.baidu.brpc.utils.ThreadPool;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutDownManager {
    private static final Logger log = LoggerFactory.getLogger(ShutDownManager.class);
    private static volatile ShutDownManager clientShutDownManager;

    public static void shutdownGlobalThreadPools() {
        log.info("invoke shutdownGlobalThreadPools");
        ThreadPool serverWorkThreadPool = ServerWorkThreadPoolInstance.getInstance();
        EpollEventLoopGroup epollBossGroup = ServerAcceptorThreadPoolInstance.getEpollInstance();
        NioEventLoopGroup nioBossGroup = ServerAcceptorThreadPoolInstance.getNioInstance();
        EpollEventLoopGroup epollWorkerGroup = ServerIoThreadPoolInstance.getEpollInstance();
        NioEventLoopGroup nioWorkerGroup = ServerIoThreadPoolInstance.getNioInstance();
        Timer clientHealthCheckerTimer = ClientHealthCheckTimerInstance.getInstance();
        Timer clientTimeOutTimer = TimerInstance.getInstance();
        if (epollBossGroup != null) {
            epollBossGroup.shutdownGracefully();
        }
        if (nioBossGroup != null) {
            nioBossGroup.shutdownGracefully();
        }
        if (epollWorkerGroup != null) {
            epollWorkerGroup.shutdownGracefully();
        }
        if (nioWorkerGroup != null) {
            nioWorkerGroup.shutdownGracefully();
        }
        if (serverWorkThreadPool != null) {
            serverWorkThreadPool.stop();
        }
        BrpcThreadPoolManager.getInstance().stopAll();
        BootstrapManager bootstrapManager = BootstrapManager.getInstance();
        bootstrapManager.removeAll();
        if (clientHealthCheckerTimer != null) {
            clientHealthCheckerTimer.stop();
        }
        if (clientTimeOutTimer != null) {
            clientTimeOutTimer.stop();
        }
    }

    private ShutDownManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShutDownManager getInstance() {
        if (clientShutDownManager != null) return clientShutDownManager;
        Class<ShutDownManager> clazz = ShutDownManager.class;
        synchronized (ShutDownManager.class) {
            if (clientShutDownManager != null) return clientShutDownManager;
            clientShutDownManager = new ShutDownManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return clientShutDownManager;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("Brpc do clean work...");
                ShutDownManager.shutdownGlobalThreadPools();
            }
        }));
    }
}

