/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.CommunicationSpiManager;
import com.baidu.brpc.client.AsyncAwareFuture;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.ServerInvokeInterceptor;
import com.baidu.brpc.protocol.NamingOptions;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.ProtocolManager;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import com.baidu.brpc.protocol.push.ServerPushProtocol;
import com.baidu.brpc.server.PushServerRpcFutureManager;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.server.ServerPushRpcFuture;
import com.baidu.brpc.server.ServerStatus;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.server.handler.RpcServerChannelIdleHandler;
import com.baidu.brpc.server.handler.RpcServerHandler;
import com.baidu.brpc.server.push.RegisterServiceImpl;
import com.baidu.brpc.thread.ServerAcceptorThreadPoolInstance;
import com.baidu.brpc.thread.ServerIoThreadPoolInstance;
import com.baidu.brpc.thread.ServerWorkThreadPoolInstance;
import com.baidu.brpc.thread.ShutDownManager;
import com.baidu.brpc.thread.TimerInstance;
import com.baidu.brpc.utils.BrpcConstants;
import com.baidu.brpc.utils.CollectionUtils;
import com.baidu.brpc.utils.CustomThreadFactory;
import com.baidu.brpc.utils.ThreadPool;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationServer {
    private static final Logger log = LoggerFactory.getLogger(CommunicationServer.class);
    protected RpcServerOptions rpcServerOptions = new RpcServerOptions();
    protected String host;
    protected int port;
    protected ServerBootstrap bootstrap;
    protected EventLoopGroup bossGroup;
    protected EventLoopGroup workerGroup;
    protected Protocol protocol;
    protected ThreadPool threadPool;
    protected List<ThreadPool> customThreadPools = new ArrayList<ThreadPool>();
    protected List<Object> serviceList = new ArrayList<Object>();
    protected ServerStatus serverStatus;
    protected AtomicBoolean stop = new AtomicBoolean(false);
    protected Timer timeoutTimer;
    protected ServiceManager serviceManager = ServiceManager.getInstance();

    public CommunicationServer(int port) {
        this(null, port, new RpcServerOptions());
    }

    public CommunicationServer(String host, int port) {
        this(host, port, new RpcServerOptions());
    }

    public CommunicationServer(int port, RpcServerOptions options) {
        this(null, port, options);
    }

    public CommunicationServer(String host, int port, RpcServerOptions options) {
        this.host = host;
        this.port = port;
        if (options != null) {
            try {
                this.rpcServerOptions.copyFrom(options);
            }
            catch (Exception ex) {
                log.warn("init options failed, so use default");
            }
        }
        CommunicationSpiManager.getInstance().loadAllExtensions(this.rpcServerOptions.getEncoding());
        ShutDownManager.getInstance();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                CommunicationServer.this.shutdown();
            }
        }));
        if (this.rpcServerOptions.getProtocolType() != null) {
            this.protocol = ProtocolManager.getInstance().getProtocol(this.rpcServerOptions.getProtocolType());
        }
        this.bootstrap = new ServerBootstrap();
        this.threadPool = this.rpcServerOptions.isGlobalThreadPoolSharing() ? ServerWorkThreadPoolInstance.getOrCreateInstance(this.rpcServerOptions.getWorkThreadNum()) : new ThreadPool(this.rpcServerOptions.getWorkThreadNum(), new CustomThreadFactory("server-work-thread"));
        if (this.rpcServerOptions.getIoEventType() == BrpcConstants.IO_EVENT_NETTY_EPOLL) {
            if (this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.bossGroup = ServerAcceptorThreadPoolInstance.getOrCreateEpollInstance(this.rpcServerOptions.getAcceptorThreadNum());
                this.workerGroup = ServerIoThreadPoolInstance.getOrCreateEpollInstance(this.rpcServerOptions.getIoThreadNum());
            } else {
                this.bossGroup = new EpollEventLoopGroup(this.rpcServerOptions.getAcceptorThreadNum(), (ThreadFactory)new CustomThreadFactory("server-acceptor-thread"));
                this.workerGroup = new EpollEventLoopGroup(this.rpcServerOptions.getIoThreadNum(), (ThreadFactory)new CustomThreadFactory("server-io-thread"));
            }
            ((EpollEventLoopGroup)this.bossGroup).setIoRatio(100);
            ((EpollEventLoopGroup)this.workerGroup).setIoRatio(100);
            this.bootstrap.channel(EpollServerSocketChannel.class);
            this.bootstrap.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
            this.bootstrap.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
            log.info("use netty epoll edge trigger mode");
        } else {
            if (this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.bossGroup = ServerAcceptorThreadPoolInstance.getOrCreateNioInstance(this.rpcServerOptions.getAcceptorThreadNum());
                this.workerGroup = ServerIoThreadPoolInstance.getOrCreateNioInstance(this.rpcServerOptions.getIoThreadNum());
            } else {
                this.bossGroup = new NioEventLoopGroup(this.rpcServerOptions.getAcceptorThreadNum(), (ThreadFactory)new CustomThreadFactory("server-acceptor-thread"));
                this.workerGroup = new NioEventLoopGroup(this.rpcServerOptions.getIoThreadNum(), (ThreadFactory)new CustomThreadFactory("server-io-thread"));
            }
            ((NioEventLoopGroup)this.bossGroup).setIoRatio(100);
            ((NioEventLoopGroup)this.workerGroup).setIoRatio(100);
            this.bootstrap.channel(NioServerSocketChannel.class);
            log.info("use jdk nio event mode");
        }
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.rpcServerOptions.getBacklog());
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.rpcServerOptions.isKeepAlive());
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.rpcServerOptions.isTcpNoDelay());
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.bootstrap.childOption(ChannelOption.SO_LINGER, (Object)this.rpcServerOptions.getSoLinger());
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.rpcServerOptions.getSendBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.rpcServerOptions.getReceiveBufferSize());
        final RpcServerHandler rpcServerHandler = new RpcServerHandler(this);
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("idleStateAwareHandler", (ChannelHandler)new IdleStateHandler(0, 0, CommunicationServer.this.rpcServerOptions.getKeepAliveTime()));
                ch.pipeline().addLast("idle", (ChannelHandler)new RpcServerChannelIdleHandler());
                ch.pipeline().addLast(new ChannelHandler[]{rpcServerHandler});
            }
        };
        this.bootstrap.group(this.bossGroup, this.workerGroup).childHandler((ChannelHandler)initializer);
        this.serverStatus = new ServerStatus(this);
        if (this.protocol instanceof ServerPushProtocol) {
            this.timeoutTimer = TimerInstance.getInstance();
            this.serviceManager.registerService(new RegisterServiceImpl(), this.threadPool);
        }
    }

    public void registerService(Object service) {
        this.registerService(service, null, null, null);
    }

    public void registerService(Object service, NamingOptions namingOptions) {
        this.registerService(service, null, namingOptions, null);
    }

    public void registerService(Object service, Class targetClass, NamingOptions namingOptions) {
        this.registerService(service, targetClass, namingOptions, null);
    }

    public void registerService(Object service, RpcServerOptions serverOptions) {
        this.registerService(service, null, null, serverOptions);
    }

    public void registerService(Object service, Class targetClass, NamingOptions namingOptions, RpcServerOptions serverOptions) {
        this.serviceList.add(service);
        ThreadPool customThreadPool = this.threadPool;
        if (serverOptions != null) {
            customThreadPool = new ThreadPool(serverOptions.getWorkThreadNum(), new CustomThreadFactory(service.getClass().getSimpleName() + "-work-thread"));
            this.customThreadPools.add(customThreadPool);
        }
        if (targetClass == null) {
            this.serviceManager.registerService(service, customThreadPool);
        } else {
            this.serviceManager.registerService(targetClass, service, customThreadPool);
        }
    }

    public void start() {
        try {
            Channel channel;
            SocketAddress localAddress;
            if (this.rpcServerOptions.getJarvisPortName() != null && System.getenv(this.rpcServerOptions.getJarvisPortName()) != null) {
                this.port = Integer.valueOf(System.getenv(this.rpcServerOptions.getJarvisPortName()));
            }
            ChannelFuture channelFuture = null != this.host ? this.bootstrap.bind(this.host, this.port) : this.bootstrap.bind(this.port);
            channelFuture.sync();
            if (this.port == 0 && channelFuture.channel() != null && (localAddress = (channel = channelFuture.channel()).localAddress()) instanceof InetSocketAddress) {
                this.port = ((InetSocketAddress)localAddress).getPort();
            }
        }
        catch (InterruptedException e) {
            log.error("server failed to start, {}", (Object)e.getMessage());
        }
        if (log.isInfoEnabled()) {
            log.info("server started on port={} success", (Object)this.port);
        }
    }

    public boolean shutdown() {
        if (this.stop.compareAndSet(false, true)) {
            if (this.bossGroup != null && !this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.bossGroup.shutdownGracefully().syncUninterruptibly();
            }
            if (this.workerGroup != null && !this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.workerGroup.shutdownGracefully().syncUninterruptibly();
            }
            if (this.threadPool != null && !this.rpcServerOptions.isGlobalThreadPoolSharing()) {
                this.threadPool.stop();
            }
            if (CollectionUtils.isNotEmpty(this.customThreadPools)) {
                log.info("clean customized thread pool");
                for (ThreadPool pool : this.customThreadPools) {
                    pool.stop();
                }
            }
            return true;
        }
        return false;
    }

    public boolean isShutdown() {
        return this.stop.get();
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public <T> AsyncAwareFuture<T> sendServerPush(Request request) {
        Channel channel = request.getChannel();
        ChannelInfo orCreateServerChannelInfo = ChannelInfo.getOrCreateServerChannelInfo(channel);
        ServerPushRpcFuture rpcFuture = new ServerPushRpcFuture();
        rpcFuture.setRpcMethodInfo(request.getRpcMethodInfo());
        rpcFuture.setCallback(request.getCallback());
        rpcFuture.setChannelInfo(orCreateServerChannelInfo);
        final long correlationId = PushServerRpcFutureManager.getInstance().putRpcFuture(rpcFuture);
        request.setCorrelationId(correlationId);
        request.getSpHead().setCorrelationId(correlationId);
        long readTimeout = request.getReadTimeoutMillis().intValue();
        long writeTimeout = request.getWriteTimeoutMillis().intValue();
        Timeout timeout = this.timeoutTimer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                long timeoutCorrelationId = correlationId;
                PushServerRpcFutureManager rpcFutureManager = PushServerRpcFutureManager.getInstance();
                RpcFuture rpcFuture = rpcFutureManager.removeRpcFuture(timeoutCorrelationId);
                if (rpcFuture == null) {
                    log.error("timeout rpc is missing, correlationId={}", (Object)timeoutCorrelationId);
                    throw new RpcException(0, "timeout rpc is missing");
                }
                long elapseTime = System.currentTimeMillis() - rpcFuture.getStartTime();
                String errMsg = String.format("request timeout,correlationId=%d,ip=%s,port=%d,elapse=%dms", timeoutCorrelationId, "?", CommunicationServer.this.port, elapseTime);
                log.info(errMsg);
                Response response = CommunicationServer.this.protocol.createResponse();
                response.setException(new RpcException(2, errMsg));
                response.setRpcFuture(rpcFuture);
                rpcFuture.handleResponse(response);
            }
        }, readTimeout, TimeUnit.MILLISECONDS);
        rpcFuture.setTimeout(timeout);
        try {
            request.retain();
            ByteBuf byteBuf = this.protocol.encodeRequest(request);
            ChannelFuture sendFuture = channel.writeAndFlush((Object)byteBuf);
            sendFuture.awaitUninterruptibly(writeTimeout);
            if (!sendFuture.isSuccess()) {
                if (!(sendFuture.cause() instanceof ClosedChannelException)) {
                    log.warn("send request failed, channelActive={}, ex=", (Object)channel.isActive(), (Object)sendFuture.cause());
                }
                String errMsg = String.format("send request failed, channelActive=%b, ex=%s", channel.isActive(), sendFuture.cause().getMessage());
                throw new RpcException(1, errMsg);
            }
        }
        catch (Exception ex) {
            timeout.cancel();
            if (ex instanceof RpcException) {
                throw (RpcException)ex;
            }
            throw new RpcException(5, ex.getMessage(), ex);
        }
        return rpcFuture;
    }

    public void execute(Request request, Response response) throws RpcException {
        new ServerInvokeInterceptor().aroundProcess(request, response, null);
    }

    public RpcServerOptions getRpcServerOptions() {
        return this.rpcServerOptions;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public List<ThreadPool> getCustomThreadPools() {
        return this.customThreadPools;
    }

    public List<Object> getServiceList() {
        return this.serviceList;
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }

    public Timer getTimeoutTimer() {
        return this.timeoutTimer;
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }
}

