/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.face;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.face.FaceVerifyRequest;
import com.baidu.aip.face.MatchRequest;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AipFace
extends BaseClient {
    public AipFace(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject detect(String image, String imageType, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/detect");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject search(String image, String imageType, String groupIdList, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("group_id_list", groupIdList);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/search");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject multiSearch(String image, String imageType, String groupIdList, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("group_id_list", groupIdList);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/multi-search");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject addUser(String image, String imageType, String groupId, String userId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("group_id", groupId);
        request.addBody("user_id", userId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/user/add");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject updateUser(String image, String imageType, String groupId, String userId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("group_id", groupId);
        request.addBody("user_id", userId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/user/update");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceDelete(String userId, String groupId, String faceToken, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("user_id", userId);
        request.addBody("group_id", groupId);
        request.addBody("face_token", faceToken);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/face/delete");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getUser(String userId, String groupId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("user_id", userId);
        request.addBody("group_id", groupId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/user/get");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceGetlist(String userId, String groupId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("user_id", userId);
        request.addBody("group_id", groupId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/face/getlist");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getGroupUsers(String groupId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/group/getusers");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject userCopy(String userId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("user_id", userId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/user/copy");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject deleteUser(String groupId, String userId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        request.addBody("user_id", userId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/user/delete");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject groupAdd(String groupId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/group/add");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject groupDelete(String groupId, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/group/delete");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getGroupList(HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceset/group/getlist");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject personVerify(String image, String imageType, String idCardNumber, String name, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("id_card_number", idCardNumber);
        request.addBody("name", name);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/person/verify");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject videoSessioncode(HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v1/faceliveness/sessioncode");
        request.setBodyFormat(EBodyFormat.FORM_KV);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject videoFaceliveness(String sessionId, byte[] video, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("session_id", sessionId);
        String base64Content = Base64Util.encode(video);
        request.addBody("video_base64", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v1/faceliveness/verify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject videoFaceliveness(String sessionId, String video, HashMap<String, String> options) {
        try {
            byte[] data = Util.readFileByBytes(video);
            return this.videoFaceliveness(sessionId, data, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject match(List<MatchRequest> input) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        JSONArray arr = new JSONArray();
        for (MatchRequest req : input) {
            arr.put((Object)req.toJsonObject());
        }
        request.addBody("body", arr.toString());
        request.setBodyFormat(EBodyFormat.RAW_JSON_ARRAY);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/match");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceverify(List<FaceVerifyRequest> input) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        JSONArray arr = new JSONArray();
        for (FaceVerifyRequest req : input) {
            arr.put((Object)req.toJsonObject());
        }
        request.addBody("body", arr.toString());
        request.setBodyFormat(EBodyFormat.RAW_JSON_ARRAY);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/faceverify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject idMatch(String idCardNum, String name, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("id_card_number", idCardNum);
        request.addBody("name", name);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v3/person/idmatch");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceMingJingVerify(String idCardNumber, String name, String image, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addBody("id_card_number", idCardNumber);
        request.addBody("name", name);
        request.addBody("image", image);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v4/mingjing/verify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceMingJingMatch(String image, String imageType, String registerImage, String registerImageType, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("register_image", registerImage);
        request.addBody("register_image_type", registerImageType);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v4/mingjing/match");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject onlinePictureLiveV4(String sdkVersion, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        request.addBody("sdk_version", sdkVersion);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v4/faceverify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceMergeV1(JSONObject imageTemplate, JSONObject imageTarget, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image_template", imageTemplate);
        request.addBody("image_target", imageTarget);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v1/merge");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceSkinSmoothV1(String image, String imageType, String actionType, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("action_type", actionType);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v1/editattr");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceLandmarkV1(String image, String imageType, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v1/landmark");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceSceneFacesetUserAdd(String image, String imageType, String groupId, String userId, String sceneType, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("group_id", groupId);
        request.addBody("user_id", userId);
        request.addBody("scene_type", sceneType);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/scene/faceset/user/add");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceSceneFacesetUserUpdate(String image, String imageType, String groupId, String userId, String sceneType, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("group_id", groupId);
        request.addBody("user_id", userId);
        request.addBody("scene_type", sceneType);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/scene/faceset/user/update");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceSceneFacesetGroupAdd(String groupId, String sceneType) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        request.addBody("scene_type", sceneType);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/scene/faceset/group/add");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceCaptureSearch(String image, String imageType, String groupIdList, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        request.addBody("group_id_list", groupIdList);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/capture/search");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceIdmatchDateV4(String name, String idCardNumber, String startDate, String endDate) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("name", name);
        request.addBody("id_card_number", idCardNumber);
        request.addBody("start_date", startDate);
        request.addBody("end_date", endDate);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v4/idmatch_date");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject faceVerifyDateV4(String name, String idCardNumber, String startDate, String endDate, String image, String imageType, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("name", name);
        request.addBody("id_card_number", idCardNumber);
        request.addBody("start_date", startDate);
        request.addBody("end_date", endDate);
        request.addBody("image", image);
        request.addBody("image_type", imageType);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v4/verify_date");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }
}

