/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.client;

import com.baidu.aip.auth.CloudAuth;
import com.baidu.aip.auth.DevAuth;
import com.baidu.aip.client.EAuthState;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipHttpClient;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.AipResponse;
import com.baidu.aip.http.HttpMethodName;
import com.baidu.aip.util.AipClientConfiguration;
import com.baidu.aip.util.AipClientConst;
import com.baidu.aip.util.SignUtil;
import com.baidu.aip.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient {
    protected String appId;
    protected String aipKey;
    protected String aipToken;
    protected String accessToken;
    protected AtomicBoolean isAuthorized;
    protected AtomicBoolean isBceKey;
    protected Calendar expireDate;
    protected AuthState state;
    protected AipClientConfiguration config;
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseClient.class);

    protected BaseClient(String appId, String apiKey, String secretKey) {
        this.appId = appId;
        this.aipKey = apiKey;
        this.aipToken = secretKey;
        this.isAuthorized = new AtomicBoolean(false);
        this.isBceKey = new AtomicBoolean(false);
        this.accessToken = null;
        this.expireDate = null;
        this.state = new AuthState();
    }

    public void setConnectionTimeoutInMillis(int timeout) {
        if (this.config == null) {
            this.config = new AipClientConfiguration();
        }
        this.config.setConnectionTimeoutMillis(timeout);
    }

    public void setSocketTimeoutInMillis(int timeout) {
        if (this.config == null) {
            this.config = new AipClientConfiguration();
        }
        this.config.setSocketTimeoutMillis(timeout);
    }

    public void setHttpProxy(String host, int port) {
        if (this.config == null) {
            this.config = new AipClientConfiguration();
        }
        this.config.setProxy(host, port, Proxy.Type.HTTP);
    }

    public void setSocketProxy(String host, int port) {
        if (this.config == null) {
            this.config = new AipClientConfiguration();
        }
        this.config.setProxy(host, port, Proxy.Type.SOCKS);
    }

    protected synchronized void getAccessToken(AipClientConfiguration config) {
        if (!this.needAuth().booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("app[%s] no need to auth", this.appId));
            }
            return;
        }
        JSONObject res = DevAuth.oauth(this.aipKey, this.aipToken, config);
        if (res == null) {
            LOGGER.warn("oauth get null response");
            return;
        }
        if (!res.isNull("access_token")) {
            this.state.transfer(true);
            this.accessToken = res.getString("access_token");
            LOGGER.info("get access_token success. current state: " + this.state.toString());
            Integer expireSec = res.getInt("expires_in");
            Calendar c = Calendar.getInstance();
            c.add(13, expireSec);
            this.expireDate = c;
            String[] scope = res.getString("scope").split(" ");
            boolean hasRight = false;
            for (String str : scope) {
                if (!AipClientConst.AI_ACCESS_RIGHT.contains(str)) continue;
                hasRight = true;
                break;
            }
            this.state.transfer(hasRight);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("current state after check priviledge: " + this.state.toString());
            }
        } else if (!res.isNull("error_code")) {
            this.state.transfer(false);
            LOGGER.warn("oauth get error, current state: " + this.state.toString());
        }
    }

    protected Boolean needAuth() {
        if (this.isBceKey.get()) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.add(5, 1);
        return !this.isAuthorized.get() || c.after(this.expireDate);
    }

    protected void preOperation(AipRequest request) {
        if (this.needAuth().booleanValue()) {
            this.getAccessToken(this.config);
        }
        request.setHttpMethod(HttpMethodName.POST);
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        request.addHeader("accept", "*/*");
        request.setConfig(this.config);
    }

    protected void postOperation(AipRequest request) {
        if (this.isBceKey.get()) {
            request.addParam("aipSdk", "java");
            String bodyStr = request.getBodyStr();
            try {
                int len = bodyStr.getBytes(request.getContentEncoding()).length;
                request.addHeader("Content-Length", Integer.toString(len));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            request.addHeader("Content-MD5", SignUtil.md5(bodyStr, request.getContentEncoding()));
            String timestamp = Util.getCanonicalTime();
            request.addHeader("Host", request.getUri().getHost());
            request.addHeader("x-bce-date", timestamp);
            request.addHeader("Authorization", CloudAuth.sign(request, this.aipKey, this.aipToken, timestamp));
        } else {
            request.addParam("aipSdk", "java");
            request.addParam("access_token", this.accessToken);
        }
    }

    protected JSONObject requestServer(AipRequest request) {
        AipResponse response = AipHttpClient.post(request);
        String resData = response.getBodyStr();
        Integer status = response.getStatus();
        if (status.equals(200) && !resData.equals("")) {
            try {
                JSONObject res = new JSONObject(resData);
                if (this.state.getState().equals((Object)EAuthState.STATE_POSSIBLE_CLOUD_USER)) {
                    boolean cloudAuthState = res.isNull("error_code") || res.getInt("error_code") != AipClientConst.IAM_ERROR_CODE.intValue();
                    this.state.transfer(cloudAuthState);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("state after cloud auth: " + this.state.toString());
                    }
                    if (!cloudAuthState) {
                        return Util.getGeneralError(AipClientConst.OPENAPI_NO_ACCESS_ERROR_CODE, "No permission to access data");
                    }
                }
                return res;
            }
            catch (JSONException e) {
                return Util.getGeneralError(-1, resData);
            }
        }
        LOGGER.warn(String.format("call failed! response status: %d, data: %s", status, resData));
        return AipError.NET_TIMEOUT_ERROR.toJsonResult();
    }

    private void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private AtomicBoolean getIsAuthorized() {
        return this.isAuthorized;
    }

    private void setIsAuthorized(boolean isAuthorized) {
        this.isAuthorized.set(isAuthorized);
    }

    private AtomicBoolean getIsBceKey() {
        return this.isBceKey;
    }

    private void setIsBceKey(boolean isBceKey) {
        this.isBceKey.set(isBceKey);
    }

    private Calendar getExpireDate() {
        return this.expireDate;
    }

    private void setExpireDate(Calendar expireDate) {
        this.expireDate = expireDate;
    }

    class AuthState {
        private EAuthState state = EAuthState.STATE_UNKNOWN;

        public String toString() {
            return this.state.name();
        }

        public EAuthState getState() {
            return this.state;
        }

        public void setState(EAuthState state) {
            this.state = state;
        }

        public void transfer(boolean value) {
            switch (this.state) {
                case STATE_UNKNOWN: {
                    if (value) {
                        this.state = EAuthState.STATE_AIP_AUTH_OK;
                        BaseClient.this.isBceKey.set(false);
                        break;
                    }
                    this.state = EAuthState.STATE_TRUE_CLOUD_USER;
                    BaseClient.this.isBceKey.set(true);
                    break;
                }
                case STATE_AIP_AUTH_OK: {
                    if (value) {
                        this.state = EAuthState.STATE_TRUE_AIP_USER;
                        BaseClient.this.isBceKey.set(false);
                        BaseClient.this.isAuthorized.set(true);
                        break;
                    }
                    this.state = EAuthState.STATE_POSSIBLE_CLOUD_USER;
                    BaseClient.this.isBceKey.set(true);
                    break;
                }
                case STATE_TRUE_AIP_USER: {
                    break;
                }
                case STATE_POSSIBLE_CLOUD_USER: {
                    if (value) {
                        this.state = EAuthState.STATE_TRUE_CLOUD_USER;
                        BaseClient.this.isBceKey.set(true);
                        break;
                    }
                    this.state = EAuthState.STATE_TRUE_AIP_USER;
                    BaseClient.this.isBceKey.set(false);
                    BaseClient.this.isAuthorized.set(true);
                    break;
                }
                case STATE_TRUE_CLOUD_USER: {
                    break;
                }
            }
        }
    }
}

