/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.observable;

import com.badoo.reaktive.base.ErrorCallback;
import com.badoo.reaktive.base.Observer;
import com.badoo.reaktive.base.exceptions.CompositeException;
import com.badoo.reaktive.disposable.Disposable;
import com.badoo.reaktive.observable.Observable;
import com.badoo.reaktive.observable.ObservableByEmitterKt;
import com.badoo.reaktive.observable.ObservableEmitter;
import com.badoo.reaktive.observable.ObservableObserver;
import com.badoo.reaktive.plugin.ReaktivePluginsJvm;
import com.badoo.reaktive.utils.HandleSourceErrorKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"take", "Lcom/badoo/reaktive/observable/Observable;", "T", "limit", "", "reaktive_debug"})
@SourceDebugExtension(value={"SMAP\nTakeObservable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TakeObservable.kt\ncom/badoo/reaktive/observable/TakeObservableKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ObservableByEmitter.kt\ncom/badoo/reaktive/observable/ObservableByEmitterKt\n+ 4 Various.kt\ncom/badoo/reaktive/observable/VariousKt\n*L\n1#1,41:1\n1#2:42\n13#3:43\n16#3:52\n13#4:44\n12#4,7:45\n*S KotlinDebug\n*F\n+ 1 TakeObservable.kt\ncom/badoo/reaktive/observable/TakeObservableKt\n*L\n14#1:43\n14#1:52\n14#1:44\n14#1:45,7\n*E\n"})
public final class TakeObservableKt {
    @NotNull
    public static final <T> Observable<T> take(@NotNull Observable<? extends T> $this$take, int limit) {
        Intrinsics.checkNotNullParameter($this$take, (String)"<this>");
        if (!(limit >= 0)) {
            boolean $i$a$-require-TakeObservableKt$take$22 = false;
            String $i$a$-require-TakeObservableKt$take$22 = "count >= 0 required but it was " + limit;
            throw new IllegalArgumentException($i$a$-require-TakeObservableKt$take$22.toString());
        }
        boolean $i$f$observable = false;
        boolean $i$f$observableUnsafe = false;
        return ReaktivePluginsJvm.onAssembleObservable(new Observable<T>($this$take, limit){
            final /* synthetic */ Observable $this_take$inlined;
            final /* synthetic */ int $limit$inlined;
            {
                this.$this_take$inlined = observable2;
                this.$limit$inlined = n;
            }

            public void subscribe(ObservableObserver<? super T> observer2) {
                Intrinsics.checkNotNullParameter(observer2, (String)"observer");
                ObservableObserver<? super T> observer3 = observer2;
                boolean bl = false;
                ObservableEmitter<? super T> emitter = ObservableByEmitterKt.onSubscribeObservable(observer3);
                ErrorCallback $this$tryCatch_u24default$iv = emitter;
                boolean $i$f$tryCatch = false;
                try {
                    boolean bl2 = false;
                    ObservableEmitter<? super T> emitter2 = emitter;
                    boolean bl3 = false;
                    this.$this_take$inlined.subscribe((Observer)new ObservableObserver<T>(emitter2, this.$limit$inlined){
                        private final /* synthetic */ ObservableEmitter<T> $$delegate_0;
                        private int remaining;
                        final /* synthetic */ ObservableEmitter<T> $emitter;
                        {
                            this.$emitter = $emitter;
                            this.$$delegate_0 = $emitter;
                            this.remaining = $limit;
                        }

                        public void onSubscribe(Disposable disposable) {
                            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
                            this.$emitter.setDisposable(disposable);
                            if (this.remaining == 0) {
                                this.onComplete();
                            }
                        }

                        public void onNext(T value) {
                            if (this.remaining > 0) {
                                int n = this.remaining;
                                this.remaining = n + -1;
                                boolean stop = this.remaining == 0;
                                this.$emitter.onNext(value);
                                if (stop) {
                                    this.onComplete();
                                }
                            }
                        }

                        public void onComplete() {
                            this.$$delegate_0.onComplete();
                        }

                        public void onError(Throwable error) {
                            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                            this.$$delegate_0.onError(error);
                        }
                    });
                }
                catch (Throwable e$iv) {
                    Throwable throwable;
                    HandleSourceErrorKt.throwIfFatal(e$iv);
                    try {
                        Throwable it;
                        Throwable bl2 = e$iv;
                        boolean bl4 = false;
                        throwable = it = bl2;
                    }
                    catch (Throwable e2$iv) {
                        HandleSourceErrorKt.throwIfFatal(e2$iv);
                        throwable = new CompositeException(e$iv, e2$iv);
                    }
                    Throwable transformedError$iv = throwable;
                    HandleSourceErrorKt.handleReaktiveError(transformedError$iv, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>((Object)$this$tryCatch_u24default$iv){

                        public final void invoke(Throwable p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ((ErrorCallback)this.receiver).onError(p0);
                        }
                    }));
                }
            }
        });
    }
}

