/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.utils.serializer;

import com.badoo.reaktive.utils.atomic.AtomicInt;
import com.badoo.reaktive.utils.queue.Queue;
import com.badoo.reaktive.utils.serializer.Serializer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b \u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0002J\u0015\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/badoo/reaktive/utils/serializer/SerializerImpl;", "T", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "queue", "Lcom/badoo/reaktive/utils/queue/Queue;", "(Lcom/badoo/reaktive/utils/queue/Queue;)V", "counter", "Lcom/badoo/reaktive/utils/atomic/AtomicInt;", "isDone", "", "accept", "", "value", "(Ljava/lang/Object;)V", "clear", "drainLoop", "onValue", "(Ljava/lang/Object;)Z", "reaktive_debug"})
@SourceDebugExtension(value={"SMAP\nSerializerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializerImpl.kt\ncom/badoo/reaktive/utils/serializer/SerializerImpl\n+ 2 SynchronizedCompat.kt\ncom/badoo/reaktive/utils/SynchronizedCompatKt\n*L\n1#1,84:1\n3#2:85\n3#2:86\n3#2:87\n*S KotlinDebug\n*F\n+ 1 SerializerImpl.kt\ncom/badoo/reaktive/utils/serializer/SerializerImpl\n*L\n34#1:85\n47#1:86\n59#1:87\n*E\n"})
public abstract class SerializerImpl<T>
implements Serializer<T> {
    @NotNull
    private final Queue<T> queue;
    private volatile boolean isDone;
    @NotNull
    private final AtomicInt counter;

    public SerializerImpl(@NotNull Queue<T> queue2) {
        Intrinsics.checkNotNullParameter(queue2, (String)"queue");
        this.queue = queue2;
        this.counter = new AtomicInt(0, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(T value) {
        if (this.isDone) {
            return;
        }
        if (this.counter.compareAndSet(0, 1)) {
            if (!this.onValue(value)) {
                this.isDone = true;
                return;
            }
            if (this.counter.addAndGet(-1) == 0) {
                return;
            }
        } else {
            Queue<T> lock$iv = this.queue;
            boolean $i$f$synchronizedCompat = false;
            Queue<T> queue2 = lock$iv;
            synchronized (queue2) {
                boolean bl = false;
                this.queue.offer(value);
                Unit unit = Unit.INSTANCE;
            }
            if (this.counter.addAndGet(1) > 1) {
                return;
            }
        }
        this.drainLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void clear() {
        void lock$iv;
        Queue<T> queue2 = this.queue;
        Queue<T> queue3 = this.queue;
        boolean $i$f$synchronizedCompat = false;
        void var4_4 = lock$iv;
        synchronized (var4_4) {
            boolean bl = false;
            queue3.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public abstract boolean onValue(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drainLoop() {
        int missed = 1;
        while (true) {
            boolean isEmpty = false;
            T value = null;
            Queue<T> lock$iv = this.queue;
            boolean $i$f$synchronizedCompat = false;
            Queue<T> queue2 = lock$iv;
            synchronized (queue2) {
                boolean bl = false;
                isEmpty = this.queue.isEmpty();
                if (!isEmpty) {
                    value = this.queue.poll();
                }
                Unit unit = Unit.INSTANCE;
            }
            if (!isEmpty) {
                if (this.onValue(value)) continue;
                this.isDone = true;
                return;
            }
            if ((missed = this.counter.addAndGet(-missed)) == 0) break;
        }
    }
}

