/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.scheduler;

import com.badoo.reaktive.scheduler.CachedExecutorServiceStrategy;
import com.badoo.reaktive.scheduler.ExecutorServiceStrategy;
import com.badoo.reaktive.utils.ExpirationPool;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/badoo/reaktive/scheduler/CachedExecutorServiceStrategy;", "Lcom/badoo/reaktive/scheduler/ExecutorServiceStrategy;", "keepAliveTimeoutMillis", "", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "(JLjava/util/concurrent/ThreadFactory;)V", "destroy", "", "get", "Ljava/util/concurrent/ScheduledExecutorService;", "recycle", "executorService", "Companion", "reaktive_debug"})
public final class CachedExecutorServiceStrategy
implements ExecutorServiceStrategy {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final long keepAliveTimeoutMillis;
    @NotNull
    private final ThreadFactory threadFactory;
    @Deprecated
    @NotNull
    private static final Lazy<ExpirationPool<ScheduledExecutorService>> pool$delegate = LazyKt.lazy((Function0)Companion.pool.2.INSTANCE);

    public CachedExecutorServiceStrategy(long keepAliveTimeoutMillis, @NotNull ThreadFactory threadFactory) {
        Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.threadFactory = threadFactory;
    }

    @Override
    @NotNull
    public ScheduledExecutorService get() {
        ScheduledExecutorService scheduledExecutorService = (ScheduledExecutorService)CachedExecutorServiceStrategy.Companion.getPool().acquire();
        if (scheduledExecutorService == null) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
            scheduledExecutorService = scheduledExecutorService2;
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newSingleThreadScheduledExecutor(threadFactory)");
        }
        return scheduledExecutorService;
    }

    @Override
    public void recycle(@NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        CachedExecutorServiceStrategy.Companion.getPool().release(executorService, this.keepAliveTimeoutMillis);
    }

    @Override
    public void destroy() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/badoo/reaktive/scheduler/CachedExecutorServiceStrategy$Companion;", "", "()V", "pool", "Lcom/badoo/reaktive/utils/ExpirationPool;", "Ljava/util/concurrent/ScheduledExecutorService;", "getPool", "()Lcom/badoo/reaktive/utils/ExpirationPool;", "pool$delegate", "Lkotlin/Lazy;", "reaktive_debug"})
    private static final class Companion {
        private Companion() {
        }

        private final ExpirationPool<ScheduledExecutorService> getPool() {
            Lazy lazy = pool$delegate;
            return (ExpirationPool)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

