/*
 * Decompiled with CFR 0.152.
 */
package com.badoo.reaktive.scheduler;

import com.badoo.reaktive.disposable.CompositeDisposable;
import com.badoo.reaktive.disposable.CompositeDisposableExtKt;
import com.badoo.reaktive.scheduler.Scheduler;
import com.badoo.reaktive.utils.atomic.AtomicBoolean;
import com.badoo.reaktive.utils.atomic.AtomicLong;
import com.badoo.reaktive.utils.clock.Clock;
import com.badoo.reaktive.utils.clock.DefaultClock;
import com.badoo.reaktive.utils.queue.PriorityQueue;
import com.badoo.reaktive.utils.serializer.Serializer;
import com.badoo.reaktive.utils.serializer.SerializerImpl;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B2\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler;", "Lcom/badoo/reaktive/scheduler/Scheduler;", "clock", "Lcom/badoo/reaktive/utils/clock/Clock;", "sleep", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "mills", "", "(Lcom/badoo/reaktive/utils/clock/Clock;Lkotlin/jvm/functions/Function1;)V", "disposables", "Lcom/badoo/reaktive/disposable/CompositeDisposable;", "destroy", "", "newExecutor", "Lcom/badoo/reaktive/scheduler/Scheduler$Executor;", "ExecutorImpl", "reaktive_debug"})
public final class TrampolineScheduler
implements Scheduler {
    @NotNull
    private final Clock clock;
    @NotNull
    private final Function1<Long, Boolean> sleep;
    @NotNull
    private final CompositeDisposable disposables;

    public TrampolineScheduler(@NotNull Clock clock, @NotNull Function1<? super Long, Boolean> sleep) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(sleep, (String)"sleep");
        this.clock = clock;
        this.sleep = sleep;
        this.disposables = new CompositeDisposable();
    }

    public /* synthetic */ TrampolineScheduler(Clock clock, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clock = (Clock)DefaultClock.INSTANCE;
        }
        this(clock, (Function1<? super Long, Boolean>)function1);
    }

    @Override
    @NotNull
    public Scheduler.Executor newExecutor() {
        return new ExecutorImpl(this.disposables, this.clock, this.sleep);
    }

    @Override
    public void destroy() {
        this.disposables.dispose();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001 B8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u001e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0016J&\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0002J&\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl;", "Lcom/badoo/reaktive/scheduler/Scheduler$Executor;", "disposables", "Lcom/badoo/reaktive/disposable/CompositeDisposable;", "clock", "Lcom/badoo/reaktive/utils/clock/Clock;", "sleep", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "mills", "", "(Lcom/badoo/reaktive/disposable/CompositeDisposable;Lcom/badoo/reaktive/utils/clock/Clock;Lkotlin/jvm/functions/Function1;)V", "_isDisposed", "Lcom/badoo/reaktive/utils/atomic/AtomicBoolean;", "isDisposed", "()Z", "serializer", "Lcom/badoo/reaktive/utils/serializer/Serializer;", "Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task;", "cancel", "", "dispose", "execute", "task", "submit", "delayMillis", "Lkotlin/Function0;", "startDelayMillis", "periodMillis", "submitRepeating", "Task", "reaktive_debug"})
    private static final class ExecutorImpl
    implements Scheduler.Executor {
        @NotNull
        private final CompositeDisposable disposables;
        @NotNull
        private final Clock clock;
        @NotNull
        private final Function1<Long, Boolean> sleep;
        @NotNull
        private final Serializer<Task> serializer;
        @NotNull
        private final AtomicBoolean _isDisposed;

        public ExecutorImpl(@NotNull CompositeDisposable disposables, @NotNull Clock clock, @NotNull Function1<? super Long, Boolean> sleep) {
            Intrinsics.checkNotNullParameter((Object)disposables, (String)"disposables");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            Intrinsics.checkNotNullParameter(sleep, (String)"sleep");
            this.disposables = disposables;
            this.clock = clock;
            this.sleep = sleep;
            Comparator comparator$iv = Task::compareTo;
            boolean $i$f$serializer = false;
            PriorityQueue priorityQueue = new PriorityQueue(comparator$iv);
            this.serializer = new SerializerImpl<Task>(priorityQueue, this){
                final /* synthetic */ ExecutorImpl $receiver$inlined;
                {
                    this.$receiver$inlined = executorImpl;
                    super($super_call_param$1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public boolean onValue(@NotNull Object value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Task p0 = (Task)value;
                    boolean bl = false;
                    return ExecutorImpl.access$execute(this.$receiver$inlined, p0);
                }
            };
            this._isDisposed = new AtomicBoolean(false, 1, null);
            CompositeDisposableExtKt.plusAssign(this.disposables, this);
        }

        @Override
        public boolean isDisposed() {
            return this._isDisposed.getValue();
        }

        @Override
        public void dispose() {
            if (this._isDisposed.compareAndSet(false, true)) {
                this.serializer.clear();
                CompositeDisposableExtKt.minusAssign(this.disposables, this);
            }
        }

        @Override
        public void submit(long delayMillis, @NotNull Function0<Unit> task) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            this.submit(delayMillis, -1L, task);
        }

        @Override
        public void submitRepeating(long startDelayMillis, long periodMillis, @NotNull Function0<Unit> task) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            this.submit(startDelayMillis, periodMillis, task);
        }

        @Override
        public void cancel() {
            this.serializer.clear();
        }

        private final void submit(long startDelayMillis, long periodMillis, Function0<Unit> task) {
            this.submit(new Task(this.clock.getUptimeMillis() + startDelayMillis, periodMillis, task));
        }

        private final void submit(Task task) {
            if (!this.isDisposed()) {
                this.serializer.accept(task);
            }
        }

        private final boolean execute(Task task) {
            if (this.isDisposed()) {
                return false;
            }
            long delay2 = task.getStartTime() - this.clock.getUptimeMillis();
            if (delay2 > 0L && !((Boolean)this.sleep.invoke((Object)delay2)).booleanValue()) {
                return false;
            }
            if (this.isDisposed()) {
                return false;
            }
            long nextStartMillis = task.getPeriodMillis() >= 0L ? this.clock.getUptimeMillis() + task.getPeriodMillis() : -1L;
            task.getTask().invoke();
            if (task.getPeriodMillis() >= 0L) {
                this.submit(Task.copy$default(task, nextStartMillis, 0L, null, 6, null));
            }
            return true;
        }

        public static final /* synthetic */ boolean access$execute(ExecutorImpl $this, Task task) {
            return $this.execute(task);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001cB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task;", "", "startTime", "", "periodMillis", "task", "Lkotlin/Function0;", "", "(JJLkotlin/jvm/functions/Function0;)V", "getPeriodMillis", "()J", "sequenceNumber", "getStartTime", "getTask", "()Lkotlin/jvm/functions/Function0;", "compareTo", "", "other", "component1", "component2", "component3", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "reaktive_debug"})
        private static final class Task
        implements Comparable<Task> {
            @NotNull
            private static final Companion Companion = new Companion(null);
            private final long startTime;
            private final long periodMillis;
            @NotNull
            private final Function0<Unit> task;
            private final long sequenceNumber;
            @Deprecated
            @NotNull
            private static final AtomicLong sequencer = new AtomicLong(0L, 1, null);

            public Task(long startTime, long periodMillis, @NotNull Function0<Unit> task) {
                Intrinsics.checkNotNullParameter(task, (String)"task");
                this.startTime = startTime;
                this.periodMillis = periodMillis;
                this.task = task;
                this.sequenceNumber = sequencer.addAndGet(1L);
            }

            public final long getStartTime() {
                return this.startTime;
            }

            public final long getPeriodMillis() {
                return this.periodMillis;
            }

            @NotNull
            public final Function0<Unit> getTask() {
                return this.task;
            }

            @Override
            public int compareTo(@NotNull Task other) {
                int n;
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this == other) {
                    n = 0;
                } else {
                    Integer n2 = Intrinsics.compare((long)this.startTime, (long)other.startTime);
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    Integer n3 = !(it == 0) ? n2 : null;
                    n = n3 != null ? n3 : Intrinsics.compare((long)this.sequenceNumber, (long)other.sequenceNumber);
                }
                return n;
            }

            public final long component1() {
                return this.startTime;
            }

            public final long component2() {
                return this.periodMillis;
            }

            @NotNull
            public final Function0<Unit> component3() {
                return this.task;
            }

            @NotNull
            public final Task copy(long startTime, long periodMillis, @NotNull Function0<Unit> task) {
                Intrinsics.checkNotNullParameter(task, (String)"task");
                return new Task(startTime, periodMillis, task);
            }

            public static /* synthetic */ Task copy$default(Task task, long l, long l2, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    l = task.startTime;
                }
                if ((n & 2) != 0) {
                    l2 = task.periodMillis;
                }
                if ((n & 4) != 0) {
                    function0 = task.task;
                }
                return task.copy(l, l2, function0);
            }

            @NotNull
            public String toString() {
                return "Task(startTime=" + this.startTime + ", periodMillis=" + this.periodMillis + ", task=" + this.task + ')';
            }

            public int hashCode() {
                int result = Long.hashCode(this.startTime);
                result = result * 31 + Long.hashCode(this.periodMillis);
                result = result * 31 + this.task.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Task)) {
                    return false;
                }
                Task task = (Task)other;
                if (this.startTime != task.startTime) {
                    return false;
                }
                if (this.periodMillis != task.periodMillis) {
                    return false;
                }
                return Intrinsics.areEqual(this.task, task.task);
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/badoo/reaktive/scheduler/TrampolineScheduler$ExecutorImpl$Task$Companion;", "", "()V", "sequencer", "Lcom/badoo/reaktive/utils/atomic/AtomicLong;", "reaktive_debug"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

