/*
 * Decompiled with CFR 0.152.
 */
package com.backbase.oss.blade.webapp;

import com.backbase.oss.blade.model.Blade;
import com.backbase.oss.blade.model.Stage;
import com.backbase.oss.blade.model.WebApp;
import com.backbase.oss.blade.utils.BladeUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BladeRegistry {
    private static BladeRegistry instance;
    private final Map<String, Blade> blades;
    private final PropertyChangeSupport propertySupport;
    private final Logger logger = LoggerFactory.getLogger(BladeRegistry.class);

    public static BladeRegistry getInstance() {
        if (instance == null) {
            instance = new BladeRegistry();
        }
        return instance;
    }

    private BladeRegistry() {
        this.blades = new LinkedHashMap();
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public void put(Blade blade) {
        this.blades.put(blade.getId(), blade);
        this.propertySupport.firePropertyChange("put", null, this.blades.values());
    }

    public void remove(String bladeId) {
        this.blades.remove(bladeId);
        this.propertySupport.firePropertyChange("remove", null, this.blades.values());
    }

    public Blade get(String id) {
        return (Blade)this.blades.get(id);
    }

    public Map<String, Blade> getBlades() {
        return this.blades;
    }

    public boolean hasBlade(String id) {
        return this.blades.containsKey(id);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public WebApp find(String name) {
        for (Blade blade : this.blades.values()) {
            for (Stage stage : blade.getStages()) {
                for (WebApp webApp : stage.getWebApps()) {
                    if (!name.equals(webApp.getName())) continue;
                    return webApp;
                }
            }
        }
        return null;
    }

    public void refresh() {
        new Thread(() -> {
            for (Blade blade : this.blades.values()) {
                try {
                    Blade updatedBlade = BladeUtils.getBladeStatus((Blade)blade);
                    this.blades.put(blade.getId(), updatedBlade);
                    blade.setReady(true);
                    blade.setRunning(true);
                    blade.setStarting(false);
                }
                catch (IOException e) {
                    this.logger.warn("Cannot get blade: {} ", (Object)blade.getId());
                    blade.setReady(false);
                    blade.setRunning(false);
                    blade.setStarting(false);
                }
            }
        }).start();
    }
}

