/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.resourcemanager.implementation.crud;

import com.azure.core.management.exception.ManagementException;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.servicebus.models.Queue;
import com.azure.resourcemanager.servicebus.models.ServiceBusNamespace;
import com.azure.spring.cloud.core.properties.resource.AzureResourceMetadata;
import com.azure.spring.cloud.resourcemanager.implementation.crud.AbstractResourceCrud;
import com.azure.spring.cloud.resourcemanager.implementation.crud.ServiceBusNamespaceCrud;
import com.azure.spring.cloud.resourcemanager.provisioning.properties.ServiceBusQueueProperties;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.util.function.Tuple2;

public class ServiceBusQueueCrud
extends AbstractResourceCrud<Queue, Tuple2<String, String>, ServiceBusQueueProperties> {
    public ServiceBusQueueCrud(AzureResourceManager azureResourceManager, AzureResourceMetadata azureResourceMetadata) {
        super(azureResourceManager, azureResourceMetadata);
    }

    @Override
    String getResourceName(Tuple2<String, String> key) {
        return (String)key.getT2();
    }

    @Override
    String getResourceType() {
        return Queue.class.getSimpleName();
    }

    @Override
    public Queue internalGet(Tuple2<String, String> namespaceAndName) {
        try {
            ServiceBusNamespace serviceBusNamespace = (ServiceBusNamespace)new ServiceBusNamespaceCrud(this.resourceManager, this.resourceMetadata).get((String)namespaceAndName.getT1());
            Assert.notNull((Object)serviceBusNamespace, (String)"The Service Bus namespace should exist first.");
            return (Queue)serviceBusNamespace.queues().getByName((String)namespaceAndName.getT2());
        }
        catch (ManagementException e) {
            if (e.getResponse().getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public Queue internalCreate(Tuple2<String, String> namespaceAndName) {
        return (Queue)((Queue.DefinitionStages.Blank)((ServiceBusNamespace)new ServiceBusNamespaceCrud(this.resourceManager, this.resourceMetadata).getOrCreate((String)namespaceAndName.getT1())).queues().define((String)namespaceAndName.getT2())).create();
    }

    @Override
    public Queue internalCreate(Tuple2<String, String> namespaceAndName, @Nullable ServiceBusQueueProperties queueProperties) {
        Queue.DefinitionStages.Blank blank = (Queue.DefinitionStages.Blank)((ServiceBusNamespace)new ServiceBusNamespaceCrud(this.resourceManager, this.resourceMetadata).getOrCreate((String)namespaceAndName.getT1())).queues().define((String)namespaceAndName.getT2());
        if (queueProperties != null) {
            if (queueProperties.getMaxSizeInMegabytes() != null) {
                blank.withSizeInMB(queueProperties.getMaxSizeInMegabytes().longValue());
            }
            if (queueProperties.getDefaultMessageTimeToLive() != null) {
                blank.withDefaultMessageTTL(queueProperties.getDefaultMessageTimeToLive());
            }
        }
        return (Queue)blank.create();
    }
}

