/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.config;

import com.azure.spring.messaging.container.ListenerContainerFactory;
import com.azure.spring.messaging.container.MessageListenerContainer;
import com.azure.spring.messaging.endpoint.AzureListenerEndpoint;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class AzureListenerEndpointRegistry
implements DisposableBean,
SmartLifecycle,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(AzureListenerEndpointRegistry.class);
    private final Map<String, MessageListenerContainer> listenerContainers = new ConcurrentHashMap<String, MessageListenerContainer>();
    @Nullable
    private ApplicationContext applicationContext;
    private boolean contextRefreshed;

    AzureListenerEndpointRegistry() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext() == this.applicationContext) {
            this.contextRefreshed = true;
        }
    }

    public Collection<MessageListenerContainer> getListenerContainers() {
        return Collections.unmodifiableCollection(this.listenerContainers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListenerContainer(AzureListenerEndpoint endpoint, ListenerContainerFactory<?> factory, boolean startImmediately) {
        Assert.notNull((Object)endpoint, (String)"Endpoint must not be null");
        Assert.notNull(factory, (String)"Factory must not be null");
        String id = endpoint.getId();
        Assert.hasText((String)id, (String)"Endpoint id must be set");
        Map<String, MessageListenerContainer> map = this.listenerContainers;
        synchronized (map) {
            if (this.listenerContainers.containsKey(id)) {
                throw new IllegalStateException("Another endpoint is already registered with id '" + id + "'");
            }
            MessageListenerContainer container = this.createListenerContainer(endpoint, factory);
            this.listenerContainers.put(id, container);
            if (startImmediately) {
                this.startIfNecessary(container);
            }
        }
    }

    public void registerListenerContainer(AzureListenerEndpoint endpoint, ListenerContainerFactory<?> factory) {
        this.registerListenerContainer(endpoint, factory, true);
    }

    protected MessageListenerContainer createListenerContainer(AzureListenerEndpoint endpoint, ListenerContainerFactory<?> factory) {
        int containerPhase;
        Object listenerContainer = factory.createListenerContainer(endpoint);
        if (listenerContainer instanceof InitializingBean) {
            try {
                ((InitializingBean)listenerContainer).afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Failed to initialize message listener container", (Throwable)ex);
            }
        }
        if ((containerPhase = listenerContainer.getPhase()) < Integer.MAX_VALUE && this.getPhase() < Integer.MAX_VALUE && this.getPhase() != containerPhase) {
            throw new IllegalStateException("Encountered phase mismatch between container factory definitions: " + this.getPhase() + " vs " + containerPhase);
        }
        return listenerContainer;
    }

    public void start() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            this.startIfNecessary(listenerContainer);
        }
    }

    public void stop() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            listenerContainer.stop();
        }
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        Collection<MessageListenerContainer> listenerContainers = this.getListenerContainers();
        AggregatingCallback aggregatingCallback = new AggregatingCallback(listenerContainers.size(), callback);
        for (MessageListenerContainer listenerContainer : listenerContainers) {
            listenerContainer.stop(aggregatingCallback);
        }
    }

    public boolean isRunning() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            if (!listenerContainer.isRunning()) continue;
            return true;
        }
        return false;
    }

    private void startIfNecessary(MessageListenerContainer listenerContainer) {
        if (this.contextRefreshed || listenerContainer.isAutoStartup()) {
            listenerContainer.start();
        }
    }

    public void destroy() {
        for (MessageListenerContainer listenerContainer : this.getListenerContainers()) {
            if (!(listenerContainer instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)listenerContainer).destroy();
            }
            catch (Throwable ex) {
                LOG.warn("Failed to destroy message listener container", ex);
            }
        }
    }

    @Nullable
    public MessageListenerContainer getListenerContainer(@NonNull String id) {
        return this.listenerContainers.get(id);
    }

    public Set<String> getListenerContainerIds() {
        return Collections.unmodifiableSet(this.listenerContainers.keySet());
    }

    public int getPhase() {
        return 0;
    }

    private static class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() == 0) {
                this.finishCallback.run();
            }
        }
    }
}

