/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class AADTrustedIssuerRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADTrustedIssuerRepository.class);
    private static final String LOGIN_MICROSOFT_ONLINE_ISSUER = "https://login.microsoftonline.com/";
    private static final String STS_WINDOWS_ISSUER = "https://sts.windows.net/";
    private static final String STS_CHINA_CLOUD_API_ISSUER = "https://sts.chinacloudapi.cn/";
    private static final String PATH_DELIMITER = "/";
    private static final String PATH_DELIMITER_V2 = "/v2.0";
    private final List<String> trustedIssuers = new ArrayList<String>();
    private final String tenantId;

    public AADTrustedIssuerRepository(String tenantId) {
        this.tenantId = tenantId;
        this.trustedIssuers.addAll(this.buildAADIssuers(PATH_DELIMITER));
        this.trustedIssuers.addAll(this.buildAADIssuers(PATH_DELIMITER_V2));
    }

    private List<String> buildAADIssuers(String delimiter) {
        return Arrays.asList(LOGIN_MICROSOFT_ONLINE_ISSUER, STS_WINDOWS_ISSUER, STS_CHINA_CLOUD_API_ISSUER).stream().map(s -> s + this.tenantId + delimiter).collect(Collectors.toList());
    }

    public void addB2CIssuer(String baseUri) {
        Assert.notNull((Object)baseUri, (String)"tenantName cannot be null.");
        this.trustedIssuers.add(String.format(this.resolveBaseUri(baseUri) + "/%s/v2.0/", this.tenantId));
    }

    public void addB2CUserFlowIssuers(String baseUri, Map<String, String> userFlows) {
        Assert.notNull(userFlows, (String)"userFlows cannot be null.");
        String resolvedBaseUri = this.resolveBaseUri(baseUri);
        userFlows.keySet().forEach(key -> this.createB2CUserFlowIssuer(resolvedBaseUri, (String)userFlows.get(key)));
    }

    private void createB2CUserFlowIssuer(String resolveBaseUri, String userFlowName) {
        this.trustedIssuers.add(String.format(resolveBaseUri + "/tfp/%s/%s/v2.0/", this.tenantId, userFlowName));
    }

    public List<String> getTrustedIssuers() {
        return Collections.unmodifiableList(this.trustedIssuers);
    }

    public boolean addTrustedIssuer(String ... issuers) {
        if (ArrayUtils.isEmpty((Object[])issuers)) {
            return false;
        }
        return this.trustedIssuers.addAll(Arrays.stream(issuers).collect(Collectors.toSet()));
    }

    private String resolveBaseUri(String baseUri) {
        Assert.notNull((Object)baseUri, (String)"baseUri cannot be null");
        try {
            URI uri = new URI(baseUri);
            return uri.getScheme() + "://" + uri.getHost();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Resolve the base uri exception.");
            throw new RuntimeException("Resolve the base uri:'" + baseUri + "' exception.");
        }
    }
}

