/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.telemetry;

import com.azure.spring.utils.PropertyLoader;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class TelemetryEventData {
    private final String name;
    @JsonProperty(value="iKey")
    private final String instrumentationKey;
    private final Tags tags = new Tags("Spring-on-azure", "Java-maven-plugin");
    private final EventData data = new EventData("EventData");
    private final String time;

    public TelemetryEventData(String eventName, @NonNull Map<String, String> properties) {
        Assert.hasText((String)eventName, (String)"Event name should contain text.");
        this.name = "Microsoft.ApplicationInsights.Event";
        this.instrumentationKey = PropertyLoader.getTelemetryInstrumentationKey();
        this.data.getBaseData().setName(eventName);
        this.data.getBaseData().setProperties(properties);
        this.time = Instant.now().toString();
    }

    public String getName() {
        return this.name;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public Tags getTags() {
        return this.tags;
    }

    public EventData getData() {
        return this.data;
    }

    public String getTime() {
        return this.time;
    }

    private static class EventData {
        private final String baseType;
        private final CustomData baseData = new CustomData();

        EventData(String baseType) {
            this.baseType = baseType;
        }

        public String getBaseType() {
            return this.baseType;
        }

        public CustomData getBaseData() {
            return this.baseData;
        }

        private static class CustomData {
            private final Integer ver = 2;
            private String name;
            private Map<String, String> properties;

            private CustomData() {
            }

            public Integer getVer() {
                return this.ver;
            }

            public String getName() {
                return this.name;
            }

            public Map<String, String> getProperties() {
                return this.properties;
            }

            private void setName(String name) {
                this.name = name;
            }

            private void setProperties(Map<String, String> properties) {
                this.properties = properties;
            }
        }
    }

    private static class Tags {
        @JsonProperty(value="ai.cloud.roleInstance")
        private final String aiCloudRoleInstance;
        @JsonProperty(value="ai.internal.sdkVersion")
        private final String aiInternalSdkVersion;

        Tags(String instance, String sdkVersion) {
            this.aiCloudRoleInstance = instance;
            this.aiInternalSdkVersion = sdkVersion;
        }

        public String getAiCloudRoleInstance() {
            return this.aiCloudRoleInstance;
        }

        public String getAiInternalSdkVersion() {
            return this.aiInternalSdkVersion;
        }
    }
}

