/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.common;

import com.azure.spring.utils.ApplicationId;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public abstract class AbstractOAuth2AuthorizationCodeGrantRequestEntityConverter
extends OAuth2AuthorizationCodeGrantRequestEntityConverter {
    protected String azureModule;

    public RequestEntity<?> convert(OAuth2AuthorizationCodeGrantRequest request) {
        RequestEntity requestEntity = super.convert(request);
        Assert.notNull((Object)requestEntity, (String)"requestEntity can not be null");
        HttpHeaders httpHeaders = this.getHttpHeaders();
        Optional.of(requestEntity).map(HttpEntity::getHeaders).ifPresent(headers -> headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).put(arg_0, arg_1)));
        MultiValueMap body = (MultiValueMap)requestEntity.getBody();
        Assert.notNull((Object)body, (String)"body can not be null");
        Optional.ofNullable(this.getHttpBody(request)).ifPresent(ext -> body.putAll((Map)ext));
        return new RequestEntity((Object)body, (MultiValueMap)httpHeaders, requestEntity.getMethod(), requestEntity.getUrl());
    }

    public HttpHeaders getHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.put("x-client-SKU", Collections.singletonList(this.azureModule));
        httpHeaders.put("x-client-VER", Collections.singletonList(ApplicationId.VERSION));
        httpHeaders.put("client-request-id", Collections.singletonList(UUID.randomUUID().toString()));
        return httpHeaders;
    }

    public MultiValueMap<String, String> getHttpBody(OAuth2AuthorizationCodeGrantRequest request) {
        return null;
    }
}

