/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.storage.resource;

import com.azure.spring.autoconfigure.storage.resource.AzureStorageResource;
import com.azure.spring.autoconfigure.storage.resource.StorageType;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.models.ShareStorageException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class FileStorageResource
extends AzureStorageResource {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageResource.class);
    private static final String MSG_FAIL_GET = "Failed to get file or container";
    private static final String MSG_FAIL_OPEN_OUTPUT = "Failed to open output stream of file";
    private static final String MSG_FAIL_CHECK_EXIST = "Failed to check existence of file or container";
    private static final String MSG_FAIL_OPEN_INPUT = "Failed to open input stream of file";
    private final ShareServiceClient shareServiceClient;
    private final ShareClient shareClient;
    private final ShareFileClient shareFileClient;
    private final String location;
    private final boolean autoCreateFiles;

    public FileStorageResource(ShareServiceClient shareServiceClient, String location) {
        this(shareServiceClient, location, false);
    }

    FileStorageResource(ShareServiceClient shareServiceClient, String location, boolean autoCreateFiles) {
        this.assertIsAzureStorageLocation(location);
        this.autoCreateFiles = autoCreateFiles;
        this.location = location;
        this.shareServiceClient = shareServiceClient;
        this.shareClient = shareServiceClient.getShareClient(this.getContainerName(location));
        this.shareFileClient = this.shareClient.getFileClient(this.getFilename(location));
    }

    public OutputStream getOutputStream() throws IOException {
        try {
            if (!this.exists()) {
                if (this.autoCreateFiles) {
                    this.create();
                } else {
                    throw new FileNotFoundException("The file was not found: " + this.location);
                }
            }
            return this.shareFileClient.getFileOutputStream();
        }
        catch (ShareStorageException e) {
            LOG.error(MSG_FAIL_OPEN_OUTPUT, (Throwable)e);
            throw new IOException(MSG_FAIL_OPEN_OUTPUT, e);
        }
    }

    public boolean exists() {
        return this.shareClient.exists() != false && this.shareFileClient.exists() != false;
    }

    public URL getURL() throws IOException {
        return new URL(this.shareFileClient.getFileUrl());
    }

    public File getFile() {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() {
        return this.shareFileClient.getProperties().getContentLength();
    }

    public long lastModified() {
        return this.shareFileClient.getProperties().getLastModified().toEpochSecond() * 1000L;
    }

    public Resource createRelative(String relativePath) {
        String newLocation = this.location + "/" + relativePath;
        return new FileStorageResource(this.shareServiceClient, newLocation, this.autoCreateFiles);
    }

    public String getFilename() {
        String[] split = this.shareFileClient.getFilePath().split("/");
        return split[split.length - 1];
    }

    public String getDescription() {
        return String.format("Azure storage account file resource [container='%s', file='%s']", this.shareFileClient.getShareName(), this.getFilename());
    }

    public InputStream getInputStream() throws IOException {
        try {
            this.assertExisted();
            return this.shareFileClient.openInputStream();
        }
        catch (ShareStorageException e) {
            LOG.error("Failed to open input stream of cloud file", (Throwable)e);
            throw new IOException("Failed to open input stream of cloud file");
        }
    }

    @Override
    StorageType getStorageType() {
        return StorageType.FILE;
    }

    private void assertExisted() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException("File or container not existed.");
        }
    }

    private void create() throws ShareStorageException {
        if (!this.shareClient.exists().booleanValue()) {
            this.shareClient.create();
        }
        if (!this.shareFileClient.exists().booleanValue()) {
            this.shareFileClient.create(1024L);
        }
    }
}

