/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ImageReference;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OSProfile;
import java.io.IOException;

public final class VirtualMachineConfiguration
implements JsonSerializable<VirtualMachineConfiguration> {
    private String vmSize;
    private ImageReference imageReference;
    private OSProfile osProfile;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineConfiguration.class);

    public String vmSize() {
        return this.vmSize;
    }

    public VirtualMachineConfiguration withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public ImageReference imageReference() {
        return this.imageReference;
    }

    public VirtualMachineConfiguration withImageReference(ImageReference imageReference) {
        this.imageReference = imageReference;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachineConfiguration withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public void validate() {
        if (this.vmSize() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmSize in model VirtualMachineConfiguration"));
        }
        if (this.imageReference() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property imageReference in model VirtualMachineConfiguration"));
        }
        this.imageReference().validate();
        if (this.osProfile() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osProfile in model VirtualMachineConfiguration"));
        }
        this.osProfile().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeJsonField("osProfile", (JsonSerializable)this.osProfile);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineConfiguration)jsonReader.readObject(reader -> {
            VirtualMachineConfiguration deserializedVirtualMachineConfiguration = new VirtualMachineConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmSize".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.vmSize = reader.getString();
                    continue;
                }
                if ("imageReference".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.imageReference = ImageReference.fromJson(reader);
                    continue;
                }
                if ("osProfile".equals(fieldName)) {
                    deserializedVirtualMachineConfiguration.osProfile = OSProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineConfiguration;
        });
    }
}

