/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDeploymentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapEnvironmentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapHighAvailabilityType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapProductType;
import java.io.IOException;

public final class SapSupportedSkusRequest
implements JsonSerializable<SapSupportedSkusRequest> {
    private String appLocation;
    private SapEnvironmentType environment;
    private SapProductType sapProduct;
    private SapDeploymentType deploymentType;
    private SapDatabaseType databaseType;
    private SapHighAvailabilityType highAvailabilityType;
    private static final ClientLogger LOGGER = new ClientLogger(SapSupportedSkusRequest.class);

    public String appLocation() {
        return this.appLocation;
    }

    public SapSupportedSkusRequest withAppLocation(String appLocation) {
        this.appLocation = appLocation;
        return this;
    }

    public SapEnvironmentType environment() {
        return this.environment;
    }

    public SapSupportedSkusRequest withEnvironment(SapEnvironmentType environment) {
        this.environment = environment;
        return this;
    }

    public SapProductType sapProduct() {
        return this.sapProduct;
    }

    public SapSupportedSkusRequest withSapProduct(SapProductType sapProduct) {
        this.sapProduct = sapProduct;
        return this;
    }

    public SapDeploymentType deploymentType() {
        return this.deploymentType;
    }

    public SapSupportedSkusRequest withDeploymentType(SapDeploymentType deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public SapDatabaseType databaseType() {
        return this.databaseType;
    }

    public SapSupportedSkusRequest withDatabaseType(SapDatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public SapHighAvailabilityType highAvailabilityType() {
        return this.highAvailabilityType;
    }

    public SapSupportedSkusRequest withHighAvailabilityType(SapHighAvailabilityType highAvailabilityType) {
        this.highAvailabilityType = highAvailabilityType;
        return this;
    }

    public void validate() {
        if (this.appLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appLocation in model SapSupportedSkusRequest"));
        }
        if (this.environment() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property environment in model SapSupportedSkusRequest"));
        }
        if (this.sapProduct() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapProduct in model SapSupportedSkusRequest"));
        }
        if (this.deploymentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deploymentType in model SapSupportedSkusRequest"));
        }
        if (this.databaseType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseType in model SapSupportedSkusRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appLocation", this.appLocation);
        jsonWriter.writeStringField("environment", this.environment == null ? null : this.environment.toString());
        jsonWriter.writeStringField("sapProduct", this.sapProduct == null ? null : this.sapProduct.toString());
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeStringField("highAvailabilityType", this.highAvailabilityType == null ? null : this.highAvailabilityType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SapSupportedSkusRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SapSupportedSkusRequest)jsonReader.readObject(reader -> {
            SapSupportedSkusRequest deserializedSapSupportedSkusRequest = new SapSupportedSkusRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appLocation".equals(fieldName)) {
                    deserializedSapSupportedSkusRequest.appLocation = reader.getString();
                    continue;
                }
                if ("environment".equals(fieldName)) {
                    deserializedSapSupportedSkusRequest.environment = SapEnvironmentType.fromString(reader.getString());
                    continue;
                }
                if ("sapProduct".equals(fieldName)) {
                    deserializedSapSupportedSkusRequest.sapProduct = SapProductType.fromString(reader.getString());
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedSapSupportedSkusRequest.deploymentType = SapDeploymentType.fromString(reader.getString());
                    continue;
                }
                if ("databaseType".equals(fieldName)) {
                    deserializedSapSupportedSkusRequest.databaseType = SapDatabaseType.fromString(reader.getString());
                    continue;
                }
                if ("highAvailabilityType".equals(fieldName)) {
                    deserializedSapSupportedSkusRequest.highAvailabilityType = SapHighAvailabilityType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapSupportedSkusRequest;
        });
    }
}

