/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseScaleMethod;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDeploymentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapEnvironmentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapHighAvailabilityType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapProductType;
import java.io.IOException;

public final class SapSizingRecommendationRequest
implements JsonSerializable<SapSizingRecommendationRequest> {
    private String appLocation;
    private SapEnvironmentType environment;
    private SapProductType sapProduct;
    private SapDeploymentType deploymentType;
    private long saps;
    private long dbMemory;
    private SapDatabaseType databaseType;
    private SapDatabaseScaleMethod dbScaleMethod;
    private SapHighAvailabilityType highAvailabilityType;
    private static final ClientLogger LOGGER = new ClientLogger(SapSizingRecommendationRequest.class);

    public String appLocation() {
        return this.appLocation;
    }

    public SapSizingRecommendationRequest withAppLocation(String appLocation) {
        this.appLocation = appLocation;
        return this;
    }

    public SapEnvironmentType environment() {
        return this.environment;
    }

    public SapSizingRecommendationRequest withEnvironment(SapEnvironmentType environment) {
        this.environment = environment;
        return this;
    }

    public SapProductType sapProduct() {
        return this.sapProduct;
    }

    public SapSizingRecommendationRequest withSapProduct(SapProductType sapProduct) {
        this.sapProduct = sapProduct;
        return this;
    }

    public SapDeploymentType deploymentType() {
        return this.deploymentType;
    }

    public SapSizingRecommendationRequest withDeploymentType(SapDeploymentType deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public long saps() {
        return this.saps;
    }

    public SapSizingRecommendationRequest withSaps(long saps) {
        this.saps = saps;
        return this;
    }

    public long dbMemory() {
        return this.dbMemory;
    }

    public SapSizingRecommendationRequest withDbMemory(long dbMemory) {
        this.dbMemory = dbMemory;
        return this;
    }

    public SapDatabaseType databaseType() {
        return this.databaseType;
    }

    public SapSizingRecommendationRequest withDatabaseType(SapDatabaseType databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public SapDatabaseScaleMethod dbScaleMethod() {
        return this.dbScaleMethod;
    }

    public SapSizingRecommendationRequest withDbScaleMethod(SapDatabaseScaleMethod dbScaleMethod) {
        this.dbScaleMethod = dbScaleMethod;
        return this;
    }

    public SapHighAvailabilityType highAvailabilityType() {
        return this.highAvailabilityType;
    }

    public SapSizingRecommendationRequest withHighAvailabilityType(SapHighAvailabilityType highAvailabilityType) {
        this.highAvailabilityType = highAvailabilityType;
        return this;
    }

    public void validate() {
        if (this.appLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appLocation in model SapSizingRecommendationRequest"));
        }
        if (this.environment() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property environment in model SapSizingRecommendationRequest"));
        }
        if (this.sapProduct() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sapProduct in model SapSizingRecommendationRequest"));
        }
        if (this.deploymentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deploymentType in model SapSizingRecommendationRequest"));
        }
        if (this.databaseType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseType in model SapSizingRecommendationRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appLocation", this.appLocation);
        jsonWriter.writeStringField("environment", this.environment == null ? null : this.environment.toString());
        jsonWriter.writeStringField("sapProduct", this.sapProduct == null ? null : this.sapProduct.toString());
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeLongField("saps", this.saps);
        jsonWriter.writeLongField("dbMemory", this.dbMemory);
        jsonWriter.writeStringField("databaseType", this.databaseType == null ? null : this.databaseType.toString());
        jsonWriter.writeStringField("dbScaleMethod", this.dbScaleMethod == null ? null : this.dbScaleMethod.toString());
        jsonWriter.writeStringField("highAvailabilityType", this.highAvailabilityType == null ? null : this.highAvailabilityType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SapSizingRecommendationRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SapSizingRecommendationRequest)jsonReader.readObject(reader -> {
            SapSizingRecommendationRequest deserializedSapSizingRecommendationRequest = new SapSizingRecommendationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appLocation".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.appLocation = reader.getString();
                    continue;
                }
                if ("environment".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.environment = SapEnvironmentType.fromString(reader.getString());
                    continue;
                }
                if ("sapProduct".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.sapProduct = SapProductType.fromString(reader.getString());
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.deploymentType = SapDeploymentType.fromString(reader.getString());
                    continue;
                }
                if ("saps".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.saps = reader.getLong();
                    continue;
                }
                if ("dbMemory".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.dbMemory = reader.getLong();
                    continue;
                }
                if ("databaseType".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.databaseType = SapDatabaseType.fromString(reader.getString());
                    continue;
                }
                if ("dbScaleMethod".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.dbScaleMethod = SapDatabaseScaleMethod.fromString(reader.getString());
                    continue;
                }
                if ("highAvailabilityType".equals(fieldName)) {
                    deserializedSapSizingRecommendationRequest.highAvailabilityType = SapHighAvailabilityType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapSizingRecommendationRequest;
        });
    }
}

