/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DeploymentConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DeploymentWithOSConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.DiscoveryConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapConfigurationType;
import java.io.IOException;

public class SapConfiguration
implements JsonSerializable<SapConfiguration> {
    private SapConfigurationType configurationType = SapConfigurationType.fromString("SapConfiguration");

    public SapConfigurationType configurationType() {
        return this.configurationType;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SapConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (SapConfiguration)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                SapConfiguration sapConfiguration;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("configurationType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Discovery".equals(discriminatorValue)) {
                    sapConfiguration = DiscoveryConfiguration.fromJson(readerToUse.reset());
                    return sapConfiguration;
                }
                if ("Deployment".equals(discriminatorValue)) {
                    sapConfiguration = DeploymentConfiguration.fromJson(readerToUse.reset());
                    return sapConfiguration;
                }
                if ("DeploymentWithOSConfig".equals(discriminatorValue)) {
                    sapConfiguration = DeploymentWithOSConfiguration.fromJson(readerToUse.reset());
                    return sapConfiguration;
                }
                sapConfiguration = SapConfiguration.fromJsonKnownDiscriminator(readerToUse.reset());
                return sapConfiguration;
            }
        });
    }

    static SapConfiguration fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (SapConfiguration)jsonReader.readObject(reader -> {
            SapConfiguration deserializedSapConfiguration = new SapConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configurationType".equals(fieldName)) {
                    deserializedSapConfiguration.configurationType = SapConfigurationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSapConfiguration;
        });
    }
}

