/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDeploymentType;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SingleServerConfiguration;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.ThreeTierConfiguration;
import java.io.IOException;

public class InfrastructureConfiguration
implements JsonSerializable<InfrastructureConfiguration> {
    private SapDeploymentType deploymentType = SapDeploymentType.fromString("InfrastructureConfiguration");
    private String appResourceGroup;
    private static final ClientLogger LOGGER = new ClientLogger(InfrastructureConfiguration.class);

    public SapDeploymentType deploymentType() {
        return this.deploymentType;
    }

    public String appResourceGroup() {
        return this.appResourceGroup;
    }

    public InfrastructureConfiguration withAppResourceGroup(String appResourceGroup) {
        this.appResourceGroup = appResourceGroup;
        return this;
    }

    public void validate() {
        if (this.appResourceGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appResourceGroup in model InfrastructureConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appResourceGroup", this.appResourceGroup);
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        return jsonWriter.writeEndObject();
    }

    public static InfrastructureConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (InfrastructureConfiguration)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                InfrastructureConfiguration infrastructureConfiguration;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("deploymentType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("SingleServer".equals(discriminatorValue)) {
                    infrastructureConfiguration = SingleServerConfiguration.fromJson(readerToUse.reset());
                    return infrastructureConfiguration;
                }
                if ("ThreeTier".equals(discriminatorValue)) {
                    infrastructureConfiguration = ThreeTierConfiguration.fromJson(readerToUse.reset());
                    return infrastructureConfiguration;
                }
                infrastructureConfiguration = InfrastructureConfiguration.fromJsonKnownDiscriminator(readerToUse.reset());
                return infrastructureConfiguration;
            }
        });
    }

    static InfrastructureConfiguration fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (InfrastructureConfiguration)jsonReader.readObject(reader -> {
            InfrastructureConfiguration deserializedInfrastructureConfiguration = new InfrastructureConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appResourceGroup".equals(fieldName)) {
                    deserializedInfrastructureConfiguration.appResourceGroup = reader.getString();
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedInfrastructureConfiguration.deploymentType = SapDeploymentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInfrastructureConfiguration;
        });
    }
}

