/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapDatabaseInstanceInner;
import java.io.IOException;
import java.util.List;

public final class SAPDatabaseInstanceListResult
implements JsonSerializable<SAPDatabaseInstanceListResult> {
    private List<SapDatabaseInstanceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(SAPDatabaseInstanceListResult.class);

    private SAPDatabaseInstanceListResult() {
    }

    public List<SapDatabaseInstanceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model SAPDatabaseInstanceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static SAPDatabaseInstanceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SAPDatabaseInstanceListResult)jsonReader.readObject(reader -> {
            SAPDatabaseInstanceListResult deserializedSAPDatabaseInstanceListResult = new SAPDatabaseInstanceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSAPDatabaseInstanceListResult.value = value = reader.readArray(reader1 -> SapDatabaseInstanceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedSAPDatabaseInstanceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSAPDatabaseInstanceListResult;
        });
    }
}

