/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.WorkloadsSapVirtualInstanceMgmtClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={WorkloadsSapVirtualInstanceMgmtClientImpl.class})
public final class WorkloadsSapVirtualInstanceMgmtClientBuilder {
    private String endpoint;
    private String subscriptionId;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public WorkloadsSapVirtualInstanceMgmtClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public WorkloadsSapVirtualInstanceMgmtClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public WorkloadsSapVirtualInstanceMgmtClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public WorkloadsSapVirtualInstanceMgmtClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public WorkloadsSapVirtualInstanceMgmtClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public WorkloadsSapVirtualInstanceMgmtClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public WorkloadsSapVirtualInstanceMgmtClientImpl buildClient() {
        String localEndpoint = this.endpoint != null ? this.endpoint : "https://management.azure.com";
        AzureEnvironment localEnvironment = this.environment != null ? this.environment : AzureEnvironment.AZURE;
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build();
        Duration localDefaultPollInterval = this.defaultPollInterval != null ? this.defaultPollInterval : Duration.ofSeconds(30L);
        SerializerAdapter localSerializerAdapter = this.serializerAdapter != null ? this.serializerAdapter : SerializerFactory.createDefaultManagementSerializerAdapter();
        WorkloadsSapVirtualInstanceMgmtClientImpl client = new WorkloadsSapVirtualInstanceMgmtClientImpl(localPipeline, localSerializerAdapter, localDefaultPollInterval, localEnvironment, localEndpoint, this.subscriptionId);
        return client;
    }
}

