/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.SapDatabaseInstancesClient;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapDatabaseInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapDatabaseInstanceImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapDatabaseInstances;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;

public final class SapDatabaseInstancesImpl
implements SapDatabaseInstances {
    private static final ClientLogger LOGGER = new ClientLogger(SapDatabaseInstancesImpl.class);
    private final SapDatabaseInstancesClient innerClient;
    private final WorkloadsSapVirtualInstanceManager serviceManager;

    public SapDatabaseInstancesImpl(SapDatabaseInstancesClient innerClient, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SapDatabaseInstance> getWithResponse(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName, Context context) {
        Response<SapDatabaseInstanceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapDatabaseInstanceImpl((SapDatabaseInstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SapDatabaseInstance get(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName) {
        SapDatabaseInstanceInner inner = this.serviceClient().get(resourceGroupName, sapVirtualInstanceName, databaseInstanceName);
        if (inner != null) {
            return new SapDatabaseInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName, databaseInstanceName);
    }

    @Override
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, context);
    }

    @Override
    public PagedIterable<SapDatabaseInstance> list(String resourceGroupName, String sapVirtualInstanceName) {
        PagedIterable<SapDatabaseInstanceInner> inner = this.serviceClient().list(resourceGroupName, sapVirtualInstanceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapDatabaseInstanceImpl((SapDatabaseInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SapDatabaseInstance> list(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        PagedIterable<SapDatabaseInstanceInner> inner = this.serviceClient().list(resourceGroupName, sapVirtualInstanceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapDatabaseInstanceImpl((SapDatabaseInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName, databaseInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName, StartRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName, databaseInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName, String databaseInstanceName, StopRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SapDatabaseInstance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String databaseInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseInstances");
        if (databaseInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseInstances'.", id)));
        }
        return (SapDatabaseInstance)this.getWithResponse(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, Context.NONE).getValue();
    }

    @Override
    public Response<SapDatabaseInstance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String databaseInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseInstances");
        if (databaseInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseInstances'.", id)));
        }
        return this.getWithResponse(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String databaseInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseInstances");
        if (databaseInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String databaseInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "databaseInstances");
        if (databaseInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, databaseInstanceName, context);
    }

    private SapDatabaseInstancesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapDatabaseInstanceImpl define(String name) {
        return new SapDatabaseInstanceImpl(name, this.manager());
    }
}

