/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadssapvirtualinstance.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadssapvirtualinstance.WorkloadsSapVirtualInstanceManager;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.SapApplicationServerInstancesClient;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.fluent.models.SapApplicationServerInstanceInner;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadssapvirtualinstance.implementation.SapApplicationServerInstanceImpl;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.OperationStatusResult;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapApplicationServerInstance;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.SapApplicationServerInstances;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StartRequest;
import com.azure.resourcemanager.workloadssapvirtualinstance.models.StopRequest;

public final class SapApplicationServerInstancesImpl
implements SapApplicationServerInstances {
    private static final ClientLogger LOGGER = new ClientLogger(SapApplicationServerInstancesImpl.class);
    private final SapApplicationServerInstancesClient innerClient;
    private final WorkloadsSapVirtualInstanceManager serviceManager;

    public SapApplicationServerInstancesImpl(SapApplicationServerInstancesClient innerClient, WorkloadsSapVirtualInstanceManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SapApplicationServerInstance> getWithResponse(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        Response<SapApplicationServerInstanceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SapApplicationServerInstanceImpl((SapApplicationServerInstanceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SapApplicationServerInstance get(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        SapApplicationServerInstanceInner inner = this.serviceClient().get(resourceGroupName, sapVirtualInstanceName, applicationInstanceName);
        if (inner != null) {
            return new SapApplicationServerInstanceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName, applicationInstanceName);
    }

    @Override
    public void delete(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context);
    }

    @Override
    public PagedIterable<SapApplicationServerInstance> list(String resourceGroupName, String sapVirtualInstanceName) {
        PagedIterable<SapApplicationServerInstanceInner> inner = this.serviceClient().list(resourceGroupName, sapVirtualInstanceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapApplicationServerInstanceImpl((SapApplicationServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SapApplicationServerInstance> list(String resourceGroupName, String sapVirtualInstanceName, Context context) {
        PagedIterable<SapApplicationServerInstanceInner> inner = this.serviceClient().list(resourceGroupName, sapVirtualInstanceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SapApplicationServerInstanceImpl((SapApplicationServerInstanceInner)((Object)inner1), this.manager()));
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName, applicationInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StartRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName, applicationInstanceName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult stop(String resourceGroupName, String sapVirtualInstanceName, String applicationInstanceName, StopRequest body, Context context) {
        OperationStatusResultInner inner = this.serviceClient().stop(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, body, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SapApplicationServerInstance getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String applicationInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "applicationInstances");
        if (applicationInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationInstances'.", id)));
        }
        return (SapApplicationServerInstance)this.getWithResponse(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, Context.NONE).getValue();
    }

    @Override
    public Response<SapApplicationServerInstance> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String applicationInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "applicationInstances");
        if (applicationInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationInstances'.", id)));
        }
        return this.getWithResponse(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String applicationInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "applicationInstances");
        if (applicationInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String sapVirtualInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "sapVirtualInstances");
        if (sapVirtualInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sapVirtualInstances'.", id)));
        }
        String applicationInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "applicationInstances");
        if (applicationInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationInstances'.", id)));
        }
        this.delete(resourceGroupName, sapVirtualInstanceName, applicationInstanceName, context);
    }

    private SapApplicationServerInstancesClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadsSapVirtualInstanceManager manager() {
        return this.serviceManager;
    }

    @Override
    public SapApplicationServerInstanceImpl define(String name) {
        return new SapApplicationServerInstanceImpl(name, this.manager());
    }
}

