/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient;
import com.azure.resourcemanager.sql.fluent.models.ManagedBackupShortTermRetentionPolicyInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.ManagedBackupShortTermRetentionPolicyListResult;
import com.azure.resourcemanager.sql.models.ManagedShortTermRetentionPolicyName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientImpl
implements ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClient {
    private final ClientLogger logger = new ClientLogger(ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientImpl.class);
    private final ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesService service;
    private final SqlManagementClientImpl client;

    ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesClientImpl(SqlManagementClientImpl client) {
        this.service = (ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesService)RestProxy.create(ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ManagedBackupShortTermRetentionPolicyInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedBackupShortTermRetentionPolicyInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.getSubscriptionId(), "2017-03-01-preview", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedBackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ManagedBackupShortTermRetentionPolicyInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedBackupShortTermRetentionPolicyInner get(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)this.getAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedBackupShortTermRetentionPolicyInner> getWithResponse(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginCreateOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedBackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedBackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedBackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedBackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)this.createOrUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (policyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter policyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        ManagedBackupShortTermRetentionPolicyInner parameters = new ManagedBackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, this.client.getSubscriptionId(), "2017-03-01-preview", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), (Type)((Object)ManagedBackupShortTermRetentionPolicyInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<ManagedBackupShortTermRetentionPolicyInner>, ManagedBackupShortTermRetentionPolicyInner> beginUpdate(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return this.beginUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return this.beginUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedBackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return this.beginUpdateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).last().flatMap(arg_0 -> ((SqlManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedBackupShortTermRetentionPolicyInner update(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)this.updateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedBackupShortTermRetentionPolicyInner update(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName, Integer retentionDays, Context context) {
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)this.updateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedBackupShortTermRetentionPolicyInner update(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, ManagedShortTermRetentionPolicyName policyName) {
        Integer retentionDays = null;
        return (ManagedBackupShortTermRetentionPolicyInner)((Object)this.updateAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, policyName, retentionDays).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        return FluxUtil.withContext(context -> this.service.listByRestorableDroppedDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, this.client.getSubscriptionId(), "2017-03-01-preview", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseSinglePageAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (restorableDroppedDatabaseId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorableDroppedDatabaseId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2017-03-01-preview";
        context = this.client.mergeContext(context);
        return this.service.listByRestorableDroppedDatabase(this.client.getEndpoint(), resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, this.client.getSubscriptionId(), "2017-03-01-preview", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ManagedBackupShortTermRetentionPolicyInner> listByRestorableDroppedDatabaseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return new PagedFlux(() -> this.listByRestorableDroppedDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId), nextLink -> this.listByRestorableDroppedDatabaseNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ManagedBackupShortTermRetentionPolicyInner> listByRestorableDroppedDatabaseAsync(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Context context) {
        return new PagedFlux(() -> this.listByRestorableDroppedDatabaseSinglePageAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, context), nextLink -> this.listByRestorableDroppedDatabaseNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedBackupShortTermRetentionPolicyInner> listByRestorableDroppedDatabase(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId) {
        return new PagedIterable(this.listByRestorableDroppedDatabaseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ManagedBackupShortTermRetentionPolicyInner> listByRestorableDroppedDatabase(String resourceGroupName, String managedInstanceName, String restorableDroppedDatabaseId, Context context) {
        return new PagedIterable(this.listByRestorableDroppedDatabaseAsync(resourceGroupName, managedInstanceName, restorableDroppedDatabaseId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listByRestorableDroppedDatabaseNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ManagedBackupShortTermRetentionPolicyInner>> listByRestorableDroppedDatabaseNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listByRestorableDroppedDatabaseNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).value(), ((ManagedBackupShortTermRetentionPolicyListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    private static interface ManagedRestorableDroppedDatabaseBackupShortTermRetentionPoliciesService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedBackupShortTermRetentionPolicyInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="restorableDroppedDatabaseId") String var4, @PathParam(value="policyName") ManagedShortTermRetentionPolicyName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, Context var8);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="restorableDroppedDatabaseId") String var4, @PathParam(value="policyName") ManagedShortTermRetentionPolicyName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ManagedBackupShortTermRetentionPolicyInner var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies/{policyName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="restorableDroppedDatabaseId") String var4, @PathParam(value="policyName") ManagedShortTermRetentionPolicyName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ManagedBackupShortTermRetentionPolicyInner var8, Context var9);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/restorableDroppedDatabases/{restorableDroppedDatabaseId}/backupShortTermRetentionPolicies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedBackupShortTermRetentionPolicyListResult>> listByRestorableDroppedDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="restorableDroppedDatabaseId") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedBackupShortTermRetentionPolicyListResult>> listByRestorableDroppedDatabaseNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

