/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DayOfWeek;
import java.io.IOException;

public final class ScheduleItem
implements JsonSerializable<ScheduleItem> {
    private DayOfWeek startDay;
    private String startTime;
    private DayOfWeek stopDay;
    private String stopTime;
    private static final ClientLogger LOGGER = new ClientLogger(ScheduleItem.class);

    public DayOfWeek startDay() {
        return this.startDay;
    }

    public ScheduleItem withStartDay(DayOfWeek startDay) {
        this.startDay = startDay;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public ScheduleItem withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public DayOfWeek stopDay() {
        return this.stopDay;
    }

    public ScheduleItem withStopDay(DayOfWeek stopDay) {
        this.stopDay = stopDay;
        return this;
    }

    public String stopTime() {
        return this.stopTime;
    }

    public ScheduleItem withStopTime(String stopTime) {
        this.stopTime = stopTime;
        return this;
    }

    public void validate() {
        if (this.startDay() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startDay in model ScheduleItem"));
        }
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model ScheduleItem"));
        }
        if (this.stopDay() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property stopDay in model ScheduleItem"));
        }
        if (this.stopTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property stopTime in model ScheduleItem"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startDay", this.startDay == null ? null : this.startDay.toString());
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("stopDay", this.stopDay == null ? null : this.stopDay.toString());
        jsonWriter.writeStringField("stopTime", this.stopTime);
        return jsonWriter.writeEndObject();
    }

    public static ScheduleItem fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleItem)jsonReader.readObject(reader -> {
            ScheduleItem deserializedScheduleItem = new ScheduleItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startDay".equals(fieldName)) {
                    deserializedScheduleItem.startDay = DayOfWeek.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedScheduleItem.startTime = reader.getString();
                    continue;
                }
                if ("stopDay".equals(fieldName)) {
                    deserializedScheduleItem.stopDay = DayOfWeek.fromString(reader.getString());
                    continue;
                }
                if ("stopTime".equals(fieldName)) {
                    deserializedScheduleItem.stopTime = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleItem;
        });
    }
}

