/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DatabaseKeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DatabaseKey
implements JsonSerializable<DatabaseKey> {
    private DatabaseKeyType type;
    private String thumbprint;
    private OffsetDateTime creationDate;
    private String subregion;

    public DatabaseKeyType type() {
        return this.type;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String subregion() {
        return this.subregion;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DatabaseKey fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseKey)jsonReader.readObject(reader -> {
            DatabaseKey deserializedDatabaseKey = new DatabaseKey();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDatabaseKey.type = DatabaseKeyType.fromString(reader.getString());
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedDatabaseKey.thumbprint = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedDatabaseKey.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("subregion".equals(fieldName)) {
                    deserializedDatabaseKey.subregion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseKey;
        });
    }
}

