/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.ServerProperties;
import com.azure.resourcemanager.sql.models.ExternalGovernanceStatus;
import com.azure.resourcemanager.sql.models.MinimalTlsVersion;
import com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.azure.resourcemanager.sql.models.ServerCreateMode;
import com.azure.resourcemanager.sql.models.ServerExternalAdministrator;
import com.azure.resourcemanager.sql.models.ServerNetworkAccessFlag;
import com.azure.resourcemanager.sql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.sql.models.ServerPublicNetworkAccessFlag;
import com.azure.resourcemanager.sql.models.ServerWorkspaceFeature;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ServerInner
extends Resource {
    private ResourceIdentity identity;
    private String kind;
    private ServerProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ServerInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ServerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ServerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ServerInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public String administratorLoginPassword() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLoginPassword();
    }

    public ServerInner withAdministratorLoginPassword(String administratorLoginPassword) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerInner withVersion(String version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public String state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public MinimalTlsVersion minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public ServerInner withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public ServerPublicNetworkAccessFlag publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ServerInner withPublicNetworkAccess(ServerPublicNetworkAccessFlag publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public ServerWorkspaceFeature workspaceFeature() {
        return this.innerProperties() == null ? null : this.innerProperties().workspaceFeature();
    }

    public String primaryUserAssignedIdentityId() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryUserAssignedIdentityId();
    }

    public ServerInner withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPrimaryUserAssignedIdentityId(primaryUserAssignedIdentityId);
        return this;
    }

    public UUID federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    public ServerInner withFederatedClientId(UUID federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    public String keyId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyId();
    }

    public ServerInner withKeyId(String keyId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withKeyId(keyId);
        return this;
    }

    public ServerExternalAdministrator administrators() {
        return this.innerProperties() == null ? null : this.innerProperties().administrators();
    }

    public ServerInner withAdministrators(ServerExternalAdministrator administrators) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministrators(administrators);
        return this;
    }

    public ServerNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().restrictOutboundNetworkAccess();
    }

    public ServerInner withRestrictOutboundNetworkAccess(ServerNetworkAccessFlag restrictOutboundNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withRestrictOutboundNetworkAccess(restrictOutboundNetworkAccess);
        return this;
    }

    public ServerNetworkAccessFlag isIPv6Enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isIPv6Enabled();
    }

    public ServerInner withIsIPv6Enabled(ServerNetworkAccessFlag isIPv6Enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withIsIPv6Enabled(isIPv6Enabled);
        return this;
    }

    public ExternalGovernanceStatus externalGovernanceStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().externalGovernanceStatus();
    }

    public Integer retentionDays() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionDays();
    }

    public ServerInner withRetentionDays(Integer retentionDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withRetentionDays(retentionDays);
        return this;
    }

    public ServerCreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public ServerInner withCreateMode(ServerCreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ServerInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerInner)((Object)jsonReader.readObject(reader -> {
            ServerInner deserializedServerInner = new ServerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServerInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedServerInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedServerInner.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedServerInner.kind = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerInner.innerProperties = ServerProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerInner;
        }));
    }
}

