/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.DistributedAvailabilityGroupDatabase;
import com.azure.resourcemanager.sql.models.FailoverModeType;
import com.azure.resourcemanager.sql.models.LinkRole;
import com.azure.resourcemanager.sql.models.ReplicationModeType;
import com.azure.resourcemanager.sql.models.SeedingModeType;
import java.io.IOException;
import java.util.List;
import java.util.UUID;

public final class DistributedAvailabilityGroupProperties
implements JsonSerializable<DistributedAvailabilityGroupProperties> {
    private String distributedAvailabilityGroupName;
    private UUID distributedAvailabilityGroupId;
    private ReplicationModeType replicationMode;
    private LinkRole partnerLinkRole;
    private String partnerAvailabilityGroupName;
    private String partnerEndpoint;
    private LinkRole instanceLinkRole;
    private String instanceAvailabilityGroupName;
    private FailoverModeType failoverMode;
    private SeedingModeType seedingMode;
    private List<DistributedAvailabilityGroupDatabase> databases;

    public String distributedAvailabilityGroupName() {
        return this.distributedAvailabilityGroupName;
    }

    public UUID distributedAvailabilityGroupId() {
        return this.distributedAvailabilityGroupId;
    }

    public ReplicationModeType replicationMode() {
        return this.replicationMode;
    }

    public DistributedAvailabilityGroupProperties withReplicationMode(ReplicationModeType replicationMode) {
        this.replicationMode = replicationMode;
        return this;
    }

    public LinkRole partnerLinkRole() {
        return this.partnerLinkRole;
    }

    public String partnerAvailabilityGroupName() {
        return this.partnerAvailabilityGroupName;
    }

    public DistributedAvailabilityGroupProperties withPartnerAvailabilityGroupName(String partnerAvailabilityGroupName) {
        this.partnerAvailabilityGroupName = partnerAvailabilityGroupName;
        return this;
    }

    public String partnerEndpoint() {
        return this.partnerEndpoint;
    }

    public DistributedAvailabilityGroupProperties withPartnerEndpoint(String partnerEndpoint) {
        this.partnerEndpoint = partnerEndpoint;
        return this;
    }

    public LinkRole instanceLinkRole() {
        return this.instanceLinkRole;
    }

    public DistributedAvailabilityGroupProperties withInstanceLinkRole(LinkRole instanceLinkRole) {
        this.instanceLinkRole = instanceLinkRole;
        return this;
    }

    public String instanceAvailabilityGroupName() {
        return this.instanceAvailabilityGroupName;
    }

    public DistributedAvailabilityGroupProperties withInstanceAvailabilityGroupName(String instanceAvailabilityGroupName) {
        this.instanceAvailabilityGroupName = instanceAvailabilityGroupName;
        return this;
    }

    public FailoverModeType failoverMode() {
        return this.failoverMode;
    }

    public DistributedAvailabilityGroupProperties withFailoverMode(FailoverModeType failoverMode) {
        this.failoverMode = failoverMode;
        return this;
    }

    public SeedingModeType seedingMode() {
        return this.seedingMode;
    }

    public DistributedAvailabilityGroupProperties withSeedingMode(SeedingModeType seedingMode) {
        this.seedingMode = seedingMode;
        return this;
    }

    public List<DistributedAvailabilityGroupDatabase> databases() {
        return this.databases;
    }

    public DistributedAvailabilityGroupProperties withDatabases(List<DistributedAvailabilityGroupDatabase> databases) {
        this.databases = databases;
        return this;
    }

    public void validate() {
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("replicationMode", this.replicationMode == null ? null : this.replicationMode.toString());
        jsonWriter.writeStringField("partnerAvailabilityGroupName", this.partnerAvailabilityGroupName);
        jsonWriter.writeStringField("partnerEndpoint", this.partnerEndpoint);
        jsonWriter.writeStringField("instanceLinkRole", this.instanceLinkRole == null ? null : this.instanceLinkRole.toString());
        jsonWriter.writeStringField("instanceAvailabilityGroupName", this.instanceAvailabilityGroupName);
        jsonWriter.writeStringField("failoverMode", this.failoverMode == null ? null : this.failoverMode.toString());
        jsonWriter.writeStringField("seedingMode", this.seedingMode == null ? null : this.seedingMode.toString());
        jsonWriter.writeArrayField("databases", this.databases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DistributedAvailabilityGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DistributedAvailabilityGroupProperties)jsonReader.readObject(reader -> {
            DistributedAvailabilityGroupProperties deserializedDistributedAvailabilityGroupProperties = new DistributedAvailabilityGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("distributedAvailabilityGroupName".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.distributedAvailabilityGroupName = reader.getString();
                    continue;
                }
                if ("distributedAvailabilityGroupId".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.distributedAvailabilityGroupId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("replicationMode".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.replicationMode = ReplicationModeType.fromString(reader.getString());
                    continue;
                }
                if ("partnerLinkRole".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.partnerLinkRole = LinkRole.fromString(reader.getString());
                    continue;
                }
                if ("partnerAvailabilityGroupName".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.partnerAvailabilityGroupName = reader.getString();
                    continue;
                }
                if ("partnerEndpoint".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.partnerEndpoint = reader.getString();
                    continue;
                }
                if ("instanceLinkRole".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.instanceLinkRole = LinkRole.fromString(reader.getString());
                    continue;
                }
                if ("instanceAvailabilityGroupName".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.instanceAvailabilityGroupName = reader.getString();
                    continue;
                }
                if ("failoverMode".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.failoverMode = FailoverModeType.fromString(reader.getString());
                    continue;
                }
                if ("seedingMode".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupProperties.seedingMode = SeedingModeType.fromString(reader.getString());
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    List databases;
                    deserializedDistributedAvailabilityGroupProperties.databases = databases = reader.readArray(reader1 -> DistributedAvailabilityGroupDatabase.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDistributedAvailabilityGroupProperties;
        });
    }
}

