/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.MoveOperationMode;
import java.io.IOException;

public final class ManagedDatabaseStartMoveDefinition
implements JsonSerializable<ManagedDatabaseStartMoveDefinition> {
    private String destinationManagedDatabaseId;
    private MoveOperationMode operationMode;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedDatabaseStartMoveDefinition.class);

    public String destinationManagedDatabaseId() {
        return this.destinationManagedDatabaseId;
    }

    public ManagedDatabaseStartMoveDefinition withDestinationManagedDatabaseId(String destinationManagedDatabaseId) {
        this.destinationManagedDatabaseId = destinationManagedDatabaseId;
        return this;
    }

    public MoveOperationMode operationMode() {
        return this.operationMode;
    }

    public ManagedDatabaseStartMoveDefinition withOperationMode(MoveOperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    public void validate() {
        if (this.destinationManagedDatabaseId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationManagedDatabaseId in model ManagedDatabaseStartMoveDefinition"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("destinationManagedDatabaseId", this.destinationManagedDatabaseId);
        jsonWriter.writeStringField("operationMode", this.operationMode == null ? null : this.operationMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedDatabaseStartMoveDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDatabaseStartMoveDefinition)jsonReader.readObject(reader -> {
            ManagedDatabaseStartMoveDefinition deserializedManagedDatabaseStartMoveDefinition = new ManagedDatabaseStartMoveDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("destinationManagedDatabaseId".equals(fieldName)) {
                    deserializedManagedDatabaseStartMoveDefinition.destinationManagedDatabaseId = reader.getString();
                    continue;
                }
                if ("operationMode".equals(fieldName)) {
                    deserializedManagedDatabaseStartMoveDefinition.operationMode = MoveOperationMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDatabaseStartMoveDefinition;
        });
    }
}

