/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.DatabaseTableProperties;
import com.azure.resourcemanager.sql.models.TableTemporalType;
import java.io.IOException;

public final class DatabaseTableInner
extends ProxyResource {
    private DatabaseTableProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DatabaseTableProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public TableTemporalType temporalType() {
        return this.innerProperties() == null ? null : this.innerProperties().temporalType();
    }

    public DatabaseTableInner withTemporalType(TableTemporalType temporalType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseTableProperties();
        }
        this.innerProperties().withTemporalType(temporalType);
        return this;
    }

    public Boolean memoryOptimized() {
        return this.innerProperties() == null ? null : this.innerProperties().memoryOptimized();
    }

    public DatabaseTableInner withMemoryOptimized(Boolean memoryOptimized) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseTableProperties();
        }
        this.innerProperties().withMemoryOptimized(memoryOptimized);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseTableInner fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseTableInner)((Object)jsonReader.readObject(reader -> {
            DatabaseTableInner deserializedDatabaseTableInner = new DatabaseTableInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDatabaseTableInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDatabaseTableInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDatabaseTableInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabaseTableInner.innerProperties = DatabaseTableProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseTableInner;
        }));
    }
}

