/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ReadWriteEndpointFailoverPolicy;
import java.io.IOException;

public final class InstanceFailoverGroupReadWriteEndpoint
implements JsonSerializable<InstanceFailoverGroupReadWriteEndpoint> {
    private ReadWriteEndpointFailoverPolicy failoverPolicy;
    private Integer failoverWithDataLossGracePeriodMinutes;
    private static final ClientLogger LOGGER = new ClientLogger(InstanceFailoverGroupReadWriteEndpoint.class);

    public ReadWriteEndpointFailoverPolicy failoverPolicy() {
        return this.failoverPolicy;
    }

    public InstanceFailoverGroupReadWriteEndpoint withFailoverPolicy(ReadWriteEndpointFailoverPolicy failoverPolicy) {
        this.failoverPolicy = failoverPolicy;
        return this;
    }

    public Integer failoverWithDataLossGracePeriodMinutes() {
        return this.failoverWithDataLossGracePeriodMinutes;
    }

    public InstanceFailoverGroupReadWriteEndpoint withFailoverWithDataLossGracePeriodMinutes(Integer failoverWithDataLossGracePeriodMinutes) {
        this.failoverWithDataLossGracePeriodMinutes = failoverWithDataLossGracePeriodMinutes;
        return this;
    }

    public void validate() {
        if (this.failoverPolicy() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property failoverPolicy in model InstanceFailoverGroupReadWriteEndpoint"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("failoverPolicy", this.failoverPolicy == null ? null : this.failoverPolicy.toString());
        jsonWriter.writeNumberField("failoverWithDataLossGracePeriodMinutes", (Number)this.failoverWithDataLossGracePeriodMinutes);
        return jsonWriter.writeEndObject();
    }

    public static InstanceFailoverGroupReadWriteEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (InstanceFailoverGroupReadWriteEndpoint)jsonReader.readObject(reader -> {
            InstanceFailoverGroupReadWriteEndpoint deserializedInstanceFailoverGroupReadWriteEndpoint = new InstanceFailoverGroupReadWriteEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("failoverPolicy".equals(fieldName)) {
                    deserializedInstanceFailoverGroupReadWriteEndpoint.failoverPolicy = ReadWriteEndpointFailoverPolicy.fromString(reader.getString());
                    continue;
                }
                if ("failoverWithDataLossGracePeriodMinutes".equals(fieldName)) {
                    deserializedInstanceFailoverGroupReadWriteEndpoint.failoverWithDataLossGracePeriodMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstanceFailoverGroupReadWriteEndpoint;
        });
    }
}

