/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WorkloadGroupProperties
implements JsonSerializable<WorkloadGroupProperties> {
    private int minResourcePercent;
    private int maxResourcePercent;
    private double minResourcePercentPerRequest;
    private Double maxResourcePercentPerRequest;
    private String importance;
    private Integer queryExecutionTimeout;

    public int minResourcePercent() {
        return this.minResourcePercent;
    }

    public WorkloadGroupProperties withMinResourcePercent(int minResourcePercent) {
        this.minResourcePercent = minResourcePercent;
        return this;
    }

    public int maxResourcePercent() {
        return this.maxResourcePercent;
    }

    public WorkloadGroupProperties withMaxResourcePercent(int maxResourcePercent) {
        this.maxResourcePercent = maxResourcePercent;
        return this;
    }

    public double minResourcePercentPerRequest() {
        return this.minResourcePercentPerRequest;
    }

    public WorkloadGroupProperties withMinResourcePercentPerRequest(double minResourcePercentPerRequest) {
        this.minResourcePercentPerRequest = minResourcePercentPerRequest;
        return this;
    }

    public Double maxResourcePercentPerRequest() {
        return this.maxResourcePercentPerRequest;
    }

    public WorkloadGroupProperties withMaxResourcePercentPerRequest(Double maxResourcePercentPerRequest) {
        this.maxResourcePercentPerRequest = maxResourcePercentPerRequest;
        return this;
    }

    public String importance() {
        return this.importance;
    }

    public WorkloadGroupProperties withImportance(String importance) {
        this.importance = importance;
        return this;
    }

    public Integer queryExecutionTimeout() {
        return this.queryExecutionTimeout;
    }

    public WorkloadGroupProperties withQueryExecutionTimeout(Integer queryExecutionTimeout) {
        this.queryExecutionTimeout = queryExecutionTimeout;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("minResourcePercent", this.minResourcePercent);
        jsonWriter.writeIntField("maxResourcePercent", this.maxResourcePercent);
        jsonWriter.writeDoubleField("minResourcePercentPerRequest", this.minResourcePercentPerRequest);
        jsonWriter.writeNumberField("maxResourcePercentPerRequest", (Number)this.maxResourcePercentPerRequest);
        jsonWriter.writeStringField("importance", this.importance);
        jsonWriter.writeNumberField("queryExecutionTimeout", (Number)this.queryExecutionTimeout);
        return jsonWriter.writeEndObject();
    }

    public static WorkloadGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkloadGroupProperties)jsonReader.readObject(reader -> {
            WorkloadGroupProperties deserializedWorkloadGroupProperties = new WorkloadGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minResourcePercent".equals(fieldName)) {
                    deserializedWorkloadGroupProperties.minResourcePercent = reader.getInt();
                    continue;
                }
                if ("maxResourcePercent".equals(fieldName)) {
                    deserializedWorkloadGroupProperties.maxResourcePercent = reader.getInt();
                    continue;
                }
                if ("minResourcePercentPerRequest".equals(fieldName)) {
                    deserializedWorkloadGroupProperties.minResourcePercentPerRequest = reader.getDouble();
                    continue;
                }
                if ("maxResourcePercentPerRequest".equals(fieldName)) {
                    deserializedWorkloadGroupProperties.maxResourcePercentPerRequest = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("importance".equals(fieldName)) {
                    deserializedWorkloadGroupProperties.importance = reader.getString();
                    continue;
                }
                if ("queryExecutionTimeout".equals(fieldName)) {
                    deserializedWorkloadGroupProperties.queryExecutionTimeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkloadGroupProperties;
        });
    }
}

