/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ExternalChildResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasResourceGroup;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import com.azure.resourcemanager.sql.fluent.models.ElasticPoolInner;
import com.azure.resourcemanager.sql.models.ElasticPoolActivity;
import com.azure.resourcemanager.sql.models.ElasticPoolEdition;
import com.azure.resourcemanager.sql.models.ElasticPoolSku;
import com.azure.resourcemanager.sql.models.ElasticPoolState;
import com.azure.resourcemanager.sql.models.Sku;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumSorage;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardStorage;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.time.OffsetDateTime;
import java.util.List;
import reactor.core.publisher.Mono;

public interface SqlElasticPool
extends ExternalChildResource<SqlElasticPool, SqlServer>,
HasInnerModel<ElasticPoolInner>,
HasResourceGroup,
Refreshable<SqlElasticPool>,
Updatable<Update> {
    public String sqlServerName();

    public OffsetDateTime creationDate();

    public ElasticPoolState state();

    public ElasticPoolEdition edition();

    public int dtu();

    public Double databaseDtuMax();

    public Double databaseDtuMin();

    public Long storageCapacity();

    public String parentId();

    public String regionName();

    public Region region();

    public List<ElasticPoolActivity> listActivities();

    public PagedFlux<ElasticPoolActivity> listActivitiesAsync();

    public List<SqlDatabase> listDatabases();

    public PagedFlux<SqlDatabase> listDatabasesAsync();

    public SqlDatabase getDatabase(String var1);

    public SqlDatabase addNewDatabase(String var1);

    public SqlDatabase addExistingDatabase(String var1);

    public SqlDatabase addExistingDatabase(SqlDatabase var1);

    public SqlDatabase removeDatabase(String var1);

    public void delete();

    public Mono<Void> deleteAsync();

    public static interface UpdateStages {

        public static interface WithDatabase {
            public Update withNewDatabase(String var1);

            public Update withExistingDatabase(String var1);

            public Update withExistingDatabase(SqlDatabase var1);
        }

        public static interface WithReservedDTUAndStorageCapacity {
            public Update withReservedDtu(SqlElasticPoolBasicEDTUs var1);

            public Update withDatabaseDtuMax(SqlElasticPoolBasicMaxEDTUs var1);

            public Update withDatabaseDtuMin(SqlElasticPoolBasicMinEDTUs var1);

            public Update withReservedDtu(SqlElasticPoolStandardEDTUs var1);

            public Update withDatabaseDtuMax(SqlElasticPoolStandardMaxEDTUs var1);

            public Update withDatabaseDtuMin(SqlElasticPoolStandardMinEDTUs var1);

            public Update withStorageCapacity(SqlElasticPoolStandardStorage var1);

            public Update withReservedDtu(SqlElasticPoolPremiumEDTUs var1);

            public Update withDatabaseDtuMax(SqlElasticPoolPremiumMaxEDTUs var1);

            public Update withDatabaseDtuMin(SqlElasticPoolPremiumMinEDTUs var1);

            public Update withStorageCapacity(SqlElasticPoolPremiumSorage var1);
        }

        public static interface WithStorageCapacity {
            public Update withStorageCapacity(Long var1);
        }

        public static interface WithDatabaseMaxCapacity {
            public Update withDatabaseMaxCapacity(double var1);
        }

        public static interface WithDatabaseMinCapacity {
            public Update withDatabaseMinCapacity(double var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithReservedDTUAndStorageCapacity,
    UpdateStages.WithDatabaseMinCapacity,
    UpdateStages.WithDatabaseMaxCapacity,
    UpdateStages.WithStorageCapacity,
    UpdateStages.WithDatabase,
    Resource.UpdateWithTags<Update>,
    Appliable<SqlElasticPool> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ParentT>
        extends WithDatabaseMinCapacity<ParentT>,
        WithDatabaseMaxCapacity<ParentT>,
        WithStorageCapacity<ParentT>,
        Attachable.InDefinition<ParentT> {
        }

        public static interface WithStorageCapacity<ParentT> {
            public WithAttach<ParentT> withStorageCapacity(Long var1);
        }

        public static interface WithDatabaseMaxCapacity<ParentT> {
            public WithAttach<ParentT> withDatabaseMaxCapacity(double var1);
        }

        public static interface WithDatabaseMinCapacity<ParentT> {
            public WithAttach<ParentT> withDatabaseMinCapacity(double var1);
        }

        public static interface WithPremiumEdition<ParentT>
        extends WithAttach<ParentT> {
            public WithPremiumEdition<ParentT> withReservedDtu(SqlElasticPoolPremiumEDTUs var1);

            public WithPremiumEdition<ParentT> withDatabaseDtuMax(SqlElasticPoolPremiumMaxEDTUs var1);

            public WithPremiumEdition<ParentT> withDatabaseDtuMin(SqlElasticPoolPremiumMinEDTUs var1);

            public WithPremiumEdition<ParentT> withStorageCapacity(SqlElasticPoolPremiumSorage var1);
        }

        public static interface WithStandardEdition<ParentT>
        extends WithAttach<ParentT> {
            public WithStandardEdition<ParentT> withReservedDtu(SqlElasticPoolStandardEDTUs var1);

            public WithStandardEdition<ParentT> withDatabaseDtuMax(SqlElasticPoolStandardMaxEDTUs var1);

            public WithStandardEdition<ParentT> withDatabaseDtuMin(SqlElasticPoolStandardMinEDTUs var1);

            public WithStandardEdition<ParentT> withStorageCapacity(SqlElasticPoolStandardStorage var1);
        }

        public static interface WithBasicEdition<ParentT>
        extends WithAttach<ParentT> {
            public WithBasicEdition<ParentT> withReservedDtu(SqlElasticPoolBasicEDTUs var1);

            public WithBasicEdition<ParentT> withDatabaseDtuMax(SqlElasticPoolBasicMaxEDTUs var1);

            public WithBasicEdition<ParentT> withDatabaseDtuMin(SqlElasticPoolBasicMinEDTUs var1);
        }

        public static interface WithEdition<ParentT> {
            public WithAttach<ParentT> withSku(ElasticPoolSku var1);

            public WithAttach<ParentT> withSku(Sku var1);

            public WithBasicEdition<ParentT> withBasicPool();

            public WithStandardEdition<ParentT> withStandardPool();

            public WithPremiumEdition<ParentT> withPremiumPool();
        }

        public static interface Blank<ParentT>
        extends WithEdition<ParentT> {
        }
    }

    public static interface SqlElasticPoolDefinition<ParentT>
    extends DefinitionStages.Blank<ParentT>,
    DefinitionStages.WithEdition<ParentT>,
    DefinitionStages.WithBasicEdition<ParentT>,
    DefinitionStages.WithStandardEdition<ParentT>,
    DefinitionStages.WithPremiumEdition<ParentT>,
    DefinitionStages.WithAttach<ParentT> {
    }
}

