/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.ServerKeyInner;
import com.azure.resourcemanager.sql.implementation.SqlChildrenOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerKeyImpl;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlServerKey;
import com.azure.resourcemanager.sql.models.SqlServerKeyOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlServerKeyOperationsImpl
extends SqlChildrenOperationsImpl<SqlServerKey>
implements SqlServerKeyOperations,
SqlServerKeyOperations.SqlServerKeyActionsDefinition {
    SqlServerKeyOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        super(parent, sqlServerManager);
        Objects.requireNonNull(parent);
    }

    SqlServerKeyOperationsImpl(SqlServerManager sqlServerManager) {
        super(null, sqlServerManager);
    }

    @Override
    public SqlServerKey getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ServerKeyInner serverKeyInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().get(resourceGroupName, sqlServerName, name);
        return serverKeyInner != null ? new SqlServerKeyImpl(resourceGroupName, sqlServerName, name, serverKeyInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlServerKey> getBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        SqlServerKeyOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().getAsync(resourceGroupName, sqlServerName, name).map(serverKeyInner -> new SqlServerKeyImpl(resourceGroupName, sqlServerName, name, (ServerKeyInner)((Object)serverKeyInner), self.sqlServerManager));
    }

    @Override
    public SqlServerKey getBySqlServer(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        ServerKeyInner serverKeyInner = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerKeys().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return serverKeyInner != null ? new SqlServerKeyImpl(name, (SqlServerImpl)sqlServer, serverKeyInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlServerKey> getBySqlServerAsync(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerKeys().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map(serverKeyInner -> new SqlServerKeyImpl(name, (SqlServerImpl)sqlServer, (ServerKeyInner)((Object)serverKeyInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Mono<Void> deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().deleteAsync(resourceGroupName, sqlServerName, name);
    }

    @Override
    public List<SqlServerKey> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlServerKeyImpl> serverKeys = new ArrayList<SqlServerKeyImpl>();
        PagedIterable<ServerKeyInner> serverKeyInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().listByServer(resourceGroupName, sqlServerName);
        for (ServerKeyInner inner : serverKeyInners) {
            serverKeys.add(new SqlServerKeyImpl(resourceGroupName, sqlServerName, inner.name(), inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(serverKeys);
    }

    @Override
    public PagedFlux<SqlServerKey> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        SqlServerKeyOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerKeys().listByServerAsync(resourceGroupName, sqlServerName).mapPage(serverKeyInner -> new SqlServerKeyImpl(resourceGroupName, sqlServerName, serverKeyInner.name(), (ServerKeyInner)((Object)serverKeyInner), self.sqlServerManager));
    }

    @Override
    public List<SqlServerKey> listBySqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        ArrayList<SqlServerKeyImpl> serverKeys = new ArrayList<SqlServerKeyImpl>();
        PagedIterable<ServerKeyInner> serverKeyInners = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerKeys().listByServer(sqlServer.resourceGroupName(), sqlServer.name());
        for (ServerKeyInner inner : serverKeyInners) {
            serverKeys.add(new SqlServerKeyImpl(inner.name(), (SqlServerImpl)sqlServer, inner, (SqlServerManager)((Object)sqlServer.manager())));
        }
        return Collections.unmodifiableList(serverKeys);
    }

    @Override
    public PagedFlux<SqlServerKey> listBySqlServerAsync(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getServerKeys().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).mapPage(serverKeyInner -> new SqlServerKeyImpl(serverKeyInner.name(), (SqlServerImpl)sqlServer, (ServerKeyInner)((Object)serverKeyInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public SqlServerKeyImpl define() {
        SqlServerKeyImpl result = new SqlServerKeyImpl("", new ServerKeyInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }
}

