/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.FailoverGroupInner;
import com.azure.resourcemanager.sql.implementation.SqlChildrenOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlFailoverGroupImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SqlFailoverGroup;
import com.azure.resourcemanager.sql.models.SqlFailoverGroupOperations;
import com.azure.resourcemanager.sql.models.SqlServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlFailoverGroupOperationsImpl
extends SqlChildrenOperationsImpl<SqlFailoverGroup>
implements SqlFailoverGroupOperations,
SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition {
    SqlFailoverGroupOperationsImpl(SqlServer parent, SqlServerManager sqlServerManager) {
        super(parent, sqlServerManager);
        Objects.requireNonNull(parent);
    }

    SqlFailoverGroupOperationsImpl(SqlServerManager sqlServerManager) {
        super(null, sqlServerManager);
    }

    @Override
    public SqlFailoverGroup getBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        FailoverGroupInner failoverGroupInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().get(resourceGroupName, sqlServerName, name);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(name, failoverGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlFailoverGroup> getBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().getAsync(resourceGroupName, sqlServerName, name).map(failoverGroupInner -> new SqlFailoverGroupImpl(name, (FailoverGroupInner)((Object)failoverGroupInner), self.sqlServerManager));
    }

    @Override
    public SqlFailoverGroup getBySqlServer(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        FailoverGroupInner failoverGroupInner = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getFailoverGroups().get(sqlServer.resourceGroupName(), sqlServer.name(), name);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(name, (SqlServerImpl)sqlServer, failoverGroupInner, (SqlServerManager)((Object)sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlFailoverGroup> getBySqlServerAsync(SqlServer sqlServer, String name) {
        Objects.requireNonNull(sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getFailoverGroups().getAsync(sqlServer.resourceGroupName(), sqlServer.name(), name).map(failoverGroupInner -> new SqlFailoverGroupImpl(name, (SqlServerImpl)sqlServer, (FailoverGroupInner)((Object)failoverGroupInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public void deleteBySqlServer(String resourceGroupName, String sqlServerName, String name) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().delete(resourceGroupName, sqlServerName, name);
    }

    @Override
    public Mono<Void> deleteBySqlServerAsync(String resourceGroupName, String sqlServerName, String name) {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().deleteAsync(resourceGroupName, sqlServerName, name);
    }

    @Override
    public List<SqlFailoverGroup> listBySqlServer(String resourceGroupName, String sqlServerName) {
        ArrayList<SqlFailoverGroupImpl> failoverGroups = new ArrayList<SqlFailoverGroupImpl>();
        PagedIterable<FailoverGroupInner> failoverGroupInners = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().listByServer(resourceGroupName, sqlServerName);
        for (FailoverGroupInner inner : failoverGroupInners) {
            failoverGroups.add(new SqlFailoverGroupImpl(inner.name(), inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(failoverGroups);
    }

    @Override
    public PagedFlux<SqlFailoverGroup> listBySqlServerAsync(String resourceGroupName, String sqlServerName) {
        SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().listByServerAsync(resourceGroupName, sqlServerName).mapPage(failoverGroupInner -> new SqlFailoverGroupImpl(failoverGroupInner.name(), (FailoverGroupInner)((Object)failoverGroupInner), self.sqlServerManager));
    }

    @Override
    public List<SqlFailoverGroup> listBySqlServer(SqlServer sqlServer) {
        ArrayList<SqlFailoverGroupImpl> failoverGroups = new ArrayList<SqlFailoverGroupImpl>();
        PagedIterable<FailoverGroupInner> failoverGroupInners = ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getFailoverGroups().listByServer(sqlServer.resourceGroupName(), sqlServer.name());
        for (FailoverGroupInner inner : failoverGroupInners) {
            failoverGroups.add(new SqlFailoverGroupImpl(inner.name(), (SqlServerImpl)sqlServer, inner, this.sqlServerManager));
        }
        return Collections.unmodifiableList(failoverGroups);
    }

    @Override
    public PagedFlux<SqlFailoverGroup> listBySqlServerAsync(SqlServer sqlServer) {
        return ((SqlManagementClient)((SqlServerManager)((Object)sqlServer.manager())).serviceClient()).getFailoverGroups().listByServerAsync(sqlServer.resourceGroupName(), sqlServer.name()).mapPage(failoverGroupInner -> new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)sqlServer, (FailoverGroupInner)((Object)failoverGroupInner), (SqlServerManager)((Object)((Object)sqlServer.manager()))));
    }

    @Override
    public SqlFailoverGroupImpl define(String name) {
        SqlFailoverGroupImpl result = new SqlFailoverGroupImpl(name, new FailoverGroupInner(), this.sqlServerManager);
        result.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
        return this.sqlServer != null ? result.withExistingSqlServer(this.sqlServer) : result;
    }

    @Override
    public SqlFailoverGroup failover(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        FailoverGroupInner failoverGroupInner = ((SqlManagementClient)((SqlServerManager)((Object)this.sqlServer.manager())).serviceClient()).getFailoverGroups().failover(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)this.sqlServer, failoverGroupInner, (SqlServerManager)((Object)this.sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlFailoverGroup> failoverAsync(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)this.sqlServer.manager())).serviceClient()).getFailoverGroups().failoverAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName).map(failoverGroupInner -> new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)this.sqlServer, (FailoverGroupInner)((Object)failoverGroupInner), (SqlServerManager)((Object)((Object)this.sqlServer.manager()))));
    }

    @Override
    public SqlFailoverGroup forceFailoverAllowDataLoss(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        FailoverGroupInner failoverGroupInner = ((SqlManagementClient)((SqlServerManager)((Object)this.sqlServer.manager())).serviceClient()).getFailoverGroups().forceFailoverAllowDataLoss(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)this.sqlServer, failoverGroupInner, (SqlServerManager)((Object)this.sqlServer.manager())) : null;
    }

    @Override
    public Mono<SqlFailoverGroup> forceFailoverAllowDataLossAsync(String failoverGroupName) {
        Objects.requireNonNull(this.sqlServer);
        return ((SqlManagementClient)((SqlServerManager)((Object)this.sqlServer.manager())).serviceClient()).getFailoverGroups().forceFailoverAllowDataLossAsync(this.sqlServer.resourceGroupName(), this.sqlServer.name(), failoverGroupName).map(failoverGroupInner -> new SqlFailoverGroupImpl(failoverGroupInner.name(), (SqlServerImpl)this.sqlServer, (FailoverGroupInner)((Object)failoverGroupInner), (SqlServerManager)((Object)((Object)this.sqlServer.manager()))));
    }

    @Override
    public SqlFailoverGroup failover(String resourceGroupName, String serverName, String failoverGroupName) {
        FailoverGroupInner failoverGroupInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().failover(resourceGroupName, serverName, failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), failoverGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlFailoverGroup> failoverAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().failoverAsync(resourceGroupName, serverName, failoverGroupName).map(failoverGroupInner -> new SqlFailoverGroupImpl(failoverGroupInner.name(), (FailoverGroupInner)((Object)failoverGroupInner), self.sqlServerManager));
    }

    @Override
    public SqlFailoverGroup forceFailoverAllowDataLoss(String resourceGroupName, String serverName, String failoverGroupName) {
        FailoverGroupInner failoverGroupInner = ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().forceFailoverAllowDataLoss(resourceGroupName, serverName, failoverGroupName);
        return failoverGroupInner != null ? new SqlFailoverGroupImpl(failoverGroupInner.name(), failoverGroupInner, this.sqlServerManager) : null;
    }

    @Override
    public Mono<SqlFailoverGroup> forceFailoverAllowDataLossAsync(String resourceGroupName, String serverName, String failoverGroupName) {
        SqlFailoverGroupOperationsImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFailoverGroups().forceFailoverAllowDataLossAsync(resourceGroupName, serverName, failoverGroupName).map(failoverGroupInner -> new SqlFailoverGroupImpl(failoverGroupInner.name(), (FailoverGroupInner)((Object)failoverGroupInner), self.sqlServerManager));
    }
}

