/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DbLevelValidationStatus;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ValidationState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ValidationSummaryItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class ValidationDetails
implements JsonSerializable<ValidationDetails> {
    private ValidationState status;
    private OffsetDateTime validationStartTimeInUtc;
    private OffsetDateTime validationEndTimeInUtc;
    private List<ValidationSummaryItem> serverLevelValidationDetails;
    private List<DbLevelValidationStatus> dbLevelValidationDetails;

    public ValidationState status() {
        return this.status;
    }

    public ValidationDetails withStatus(ValidationState status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime validationStartTimeInUtc() {
        return this.validationStartTimeInUtc;
    }

    public ValidationDetails withValidationStartTimeInUtc(OffsetDateTime validationStartTimeInUtc) {
        this.validationStartTimeInUtc = validationStartTimeInUtc;
        return this;
    }

    public OffsetDateTime validationEndTimeInUtc() {
        return this.validationEndTimeInUtc;
    }

    public ValidationDetails withValidationEndTimeInUtc(OffsetDateTime validationEndTimeInUtc) {
        this.validationEndTimeInUtc = validationEndTimeInUtc;
        return this;
    }

    public List<ValidationSummaryItem> serverLevelValidationDetails() {
        return this.serverLevelValidationDetails;
    }

    public ValidationDetails withServerLevelValidationDetails(List<ValidationSummaryItem> serverLevelValidationDetails) {
        this.serverLevelValidationDetails = serverLevelValidationDetails;
        return this;
    }

    public List<DbLevelValidationStatus> dbLevelValidationDetails() {
        return this.dbLevelValidationDetails;
    }

    public ValidationDetails withDbLevelValidationDetails(List<DbLevelValidationStatus> dbLevelValidationDetails) {
        this.dbLevelValidationDetails = dbLevelValidationDetails;
        return this;
    }

    public void validate() {
        if (this.serverLevelValidationDetails() != null) {
            this.serverLevelValidationDetails().forEach(e -> e.validate());
        }
        if (this.dbLevelValidationDetails() != null) {
            this.dbLevelValidationDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("validationStartTimeInUtc", this.validationStartTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validationStartTimeInUtc));
        jsonWriter.writeStringField("validationEndTimeInUtc", this.validationEndTimeInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.validationEndTimeInUtc));
        jsonWriter.writeArrayField("serverLevelValidationDetails", this.serverLevelValidationDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dbLevelValidationDetails", this.dbLevelValidationDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ValidationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ValidationDetails)jsonReader.readObject(reader -> {
            ValidationDetails deserializedValidationDetails = new ValidationDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedValidationDetails.status = ValidationState.fromString(reader.getString());
                    continue;
                }
                if ("validationStartTimeInUtc".equals(fieldName)) {
                    deserializedValidationDetails.validationStartTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("validationEndTimeInUtc".equals(fieldName)) {
                    deserializedValidationDetails.validationEndTimeInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("serverLevelValidationDetails".equals(fieldName)) {
                    List serverLevelValidationDetails;
                    deserializedValidationDetails.serverLevelValidationDetails = serverLevelValidationDetails = reader.readArray(reader1 -> ValidationSummaryItem.fromJson(reader1));
                    continue;
                }
                if ("dbLevelValidationDetails".equals(fieldName)) {
                    List dbLevelValidationDetails;
                    deserializedValidationDetails.dbLevelValidationDetails = dbLevelValidationDetails = reader.readArray(reader1 -> DbLevelValidationStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidationDetails;
        });
    }
}

