/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DatabaseMigrationState;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationSubstate;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ValidationDetails;
import java.io.IOException;
import java.util.Map;

public final class MigrationSubstateDetails
implements JsonSerializable<MigrationSubstateDetails> {
    private MigrationSubstate currentSubState;
    private Map<String, DatabaseMigrationState> dbDetails;
    private ValidationDetails validationDetails;

    public MigrationSubstate currentSubState() {
        return this.currentSubState;
    }

    public Map<String, DatabaseMigrationState> dbDetails() {
        return this.dbDetails;
    }

    public MigrationSubstateDetails withDbDetails(Map<String, DatabaseMigrationState> dbDetails) {
        this.dbDetails = dbDetails;
        return this;
    }

    public ValidationDetails validationDetails() {
        return this.validationDetails;
    }

    public MigrationSubstateDetails withValidationDetails(ValidationDetails validationDetails) {
        this.validationDetails = validationDetails;
        return this;
    }

    public void validate() {
        if (this.dbDetails() != null) {
            this.dbDetails().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.validationDetails() != null) {
            this.validationDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("dbDetails", this.dbDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("validationDetails", (JsonSerializable)this.validationDetails);
        return jsonWriter.writeEndObject();
    }

    public static MigrationSubstateDetails fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationSubstateDetails)jsonReader.readObject(reader -> {
            MigrationSubstateDetails deserializedMigrationSubstateDetails = new MigrationSubstateDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("currentSubState".equals(fieldName)) {
                    deserializedMigrationSubstateDetails.currentSubState = MigrationSubstate.fromString(reader.getString());
                    continue;
                }
                if ("dbDetails".equals(fieldName)) {
                    Map dbDetails;
                    deserializedMigrationSubstateDetails.dbDetails = dbDetails = reader.readMap(reader1 -> DatabaseMigrationState.fromJson(reader1));
                    continue;
                }
                if ("validationDetails".equals(fieldName)) {
                    deserializedMigrationSubstateDetails.validationDetails = ValidationDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationSubstateDetails;
        });
    }
}

