/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.DataEncryptionType;
import com.azure.resourcemanager.postgresqlflexibleserver.models.EncryptionKeyStatus;
import java.io.IOException;

public final class DataEncryption
implements JsonSerializable<DataEncryption> {
    private String primaryKeyUri;
    private String primaryUserAssignedIdentityId;
    private String geoBackupKeyUri;
    private String geoBackupUserAssignedIdentityId;
    private DataEncryptionType type;
    private EncryptionKeyStatus primaryEncryptionKeyStatus;
    private EncryptionKeyStatus geoBackupEncryptionKeyStatus;

    public String primaryKeyUri() {
        return this.primaryKeyUri;
    }

    public DataEncryption withPrimaryKeyUri(String primaryKeyUri) {
        this.primaryKeyUri = primaryKeyUri;
        return this;
    }

    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    public DataEncryption withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    public String geoBackupKeyUri() {
        return this.geoBackupKeyUri;
    }

    public DataEncryption withGeoBackupKeyUri(String geoBackupKeyUri) {
        this.geoBackupKeyUri = geoBackupKeyUri;
        return this;
    }

    public String geoBackupUserAssignedIdentityId() {
        return this.geoBackupUserAssignedIdentityId;
    }

    public DataEncryption withGeoBackupUserAssignedIdentityId(String geoBackupUserAssignedIdentityId) {
        this.geoBackupUserAssignedIdentityId = geoBackupUserAssignedIdentityId;
        return this;
    }

    public DataEncryptionType type() {
        return this.type;
    }

    public DataEncryption withType(DataEncryptionType type) {
        this.type = type;
        return this;
    }

    public EncryptionKeyStatus primaryEncryptionKeyStatus() {
        return this.primaryEncryptionKeyStatus;
    }

    public DataEncryption withPrimaryEncryptionKeyStatus(EncryptionKeyStatus primaryEncryptionKeyStatus) {
        this.primaryEncryptionKeyStatus = primaryEncryptionKeyStatus;
        return this;
    }

    public EncryptionKeyStatus geoBackupEncryptionKeyStatus() {
        return this.geoBackupEncryptionKeyStatus;
    }

    public DataEncryption withGeoBackupEncryptionKeyStatus(EncryptionKeyStatus geoBackupEncryptionKeyStatus) {
        this.geoBackupEncryptionKeyStatus = geoBackupEncryptionKeyStatus;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryKeyURI", this.primaryKeyUri);
        jsonWriter.writeStringField("primaryUserAssignedIdentityId", this.primaryUserAssignedIdentityId);
        jsonWriter.writeStringField("geoBackupKeyURI", this.geoBackupKeyUri);
        jsonWriter.writeStringField("geoBackupUserAssignedIdentityId", this.geoBackupUserAssignedIdentityId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("primaryEncryptionKeyStatus", this.primaryEncryptionKeyStatus == null ? null : this.primaryEncryptionKeyStatus.toString());
        jsonWriter.writeStringField("geoBackupEncryptionKeyStatus", this.geoBackupEncryptionKeyStatus == null ? null : this.geoBackupEncryptionKeyStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataEncryption fromJson(JsonReader jsonReader) throws IOException {
        return (DataEncryption)jsonReader.readObject(reader -> {
            DataEncryption deserializedDataEncryption = new DataEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primaryKeyURI".equals(fieldName)) {
                    deserializedDataEncryption.primaryKeyUri = reader.getString();
                    continue;
                }
                if ("primaryUserAssignedIdentityId".equals(fieldName)) {
                    deserializedDataEncryption.primaryUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("geoBackupKeyURI".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupKeyUri = reader.getString();
                    continue;
                }
                if ("geoBackupUserAssignedIdentityId".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataEncryption.type = DataEncryptionType.fromString(reader.getString());
                    continue;
                }
                if ("primaryEncryptionKeyStatus".equals(fieldName)) {
                    deserializedDataEncryption.primaryEncryptionKeyStatus = EncryptionKeyStatus.fromString(reader.getString());
                    continue;
                }
                if ("geoBackupEncryptionKeyStatus".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupEncryptionKeyStatus = EncryptionKeyStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataEncryption;
        });
    }
}

