/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ServerThreatProtectionSettingsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.AdvancedThreatProtectionSettingsModelInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ThreatProtectionName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServerThreatProtectionSettingsClientImpl
implements ServerThreatProtectionSettingsClient {
    private final ServerThreatProtectionSettingsService service;
    private final PostgreSqlManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ServerThreatProtectionSettingsClientImpl.class);

    ServerThreatProtectionSettingsClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (ServerThreatProtectionSettingsService)RestProxy.create(ServerThreatProtectionSettingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (threatProtectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter threatProtectionName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, threatProtectionName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (threatProtectionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter threatProtectionName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, threatProtectionName, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (threatProtectionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter threatProtectionName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serverName, threatProtectionName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AdvancedThreatProtectionSettingsModelInner>, AdvancedThreatProtectionSettingsModelInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, threatProtectionName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AdvancedThreatProtectionSettingsModelInner.class), (Type)((Object)AdvancedThreatProtectionSettingsModelInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AdvancedThreatProtectionSettingsModelInner>, AdvancedThreatProtectionSettingsModelInner> beginCreateOrUpdate(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, serverName, threatProtectionName, parameters);
        return this.client.getLroResult(response, (Type)((Object)AdvancedThreatProtectionSettingsModelInner.class), (Type)((Object)AdvancedThreatProtectionSettingsModelInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AdvancedThreatProtectionSettingsModelInner>, AdvancedThreatProtectionSettingsModelInner> beginCreateOrUpdate(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, serverName, threatProtectionName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)AdvancedThreatProtectionSettingsModelInner.class), (Type)((Object)AdvancedThreatProtectionSettingsModelInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AdvancedThreatProtectionSettingsModelInner> createOrUpdateAsync(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, threatProtectionName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdvancedThreatProtectionSettingsModelInner createOrUpdate(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters) {
        return (AdvancedThreatProtectionSettingsModelInner)((Object)this.beginCreateOrUpdate(resourceGroupName, serverName, threatProtectionName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdvancedThreatProtectionSettingsModelInner createOrUpdate(String resourceGroupName, String serverName, ThreatProtectionName threatProtectionName, AdvancedThreatProtectionSettingsModelInner parameters, Context context) {
        return (AdvancedThreatProtectionSettingsModelInner)((Object)this.beginCreateOrUpdate(resourceGroupName, serverName, threatProtectionName, parameters, context).getFinalResult());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagementClientServerThreatProtectionSettings")
    public static interface ServerThreatProtectionSettingsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="threatProtectionName") ThreatProtectionName var6, @BodyParam(value="application/json") AdvancedThreatProtectionSettingsModelInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/advancedThreatProtectionSettings/{threatProtectionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="threatProtectionName") ThreatProtectionName var6, @BodyParam(value="application/json") AdvancedThreatProtectionSettingsModelInner var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

