/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.NameAvailabilitiesClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.NameAvailabilityModelInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.NameAvailabilityModelImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.postgresqlflexibleserver.models.NameAvailabilities;
import com.azure.resourcemanager.postgresqlflexibleserver.models.NameAvailabilityModel;

public final class NameAvailabilitiesImpl
implements NameAvailabilities {
    private static final ClientLogger LOGGER = new ClientLogger(NameAvailabilitiesImpl.class);
    private final NameAvailabilitiesClient innerClient;
    private final PostgreSqlManager serviceManager;

    public NameAvailabilitiesImpl(NameAvailabilitiesClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NameAvailabilityModel> checkGloballyWithResponse(CheckNameAvailabilityRequest parameters, Context context) {
        Response<NameAvailabilityModelInner> inner = this.serviceClient().checkGloballyWithResponse(parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NameAvailabilityModelImpl((NameAvailabilityModelInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NameAvailabilityModel checkGlobally(CheckNameAvailabilityRequest parameters) {
        NameAvailabilityModelInner inner = this.serviceClient().checkGlobally(parameters);
        if (inner != null) {
            return new NameAvailabilityModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<NameAvailabilityModel> checkWithLocationWithResponse(String locationName, CheckNameAvailabilityRequest parameters, Context context) {
        Response<NameAvailabilityModelInner> inner = this.serviceClient().checkWithLocationWithResponse(locationName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NameAvailabilityModelImpl((NameAvailabilityModelInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NameAvailabilityModel checkWithLocation(String locationName, CheckNameAvailabilityRequest parameters) {
        NameAvailabilityModelInner inner = this.serviceClient().checkWithLocation(locationName, parameters);
        if (inner != null) {
            return new NameAvailabilityModelImpl(inner, this.manager());
        }
        return null;
    }

    private NameAvailabilitiesClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

