/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.CapabilitiesByServersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.CapabilityInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.CapabilityImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.CapabilitiesByServers;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Capability;

public final class CapabilitiesByServersImpl
implements CapabilitiesByServers {
    private static final ClientLogger LOGGER = new ClientLogger(CapabilitiesByServersImpl.class);
    private final CapabilitiesByServersClient innerClient;
    private final PostgreSqlManager serviceManager;

    public CapabilitiesByServersImpl(CapabilitiesByServersClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Capability> list(String resourceGroupName, String serverName) {
        PagedIterable<CapabilityInner> inner = this.serviceClient().list(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityImpl((CapabilityInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<Capability> list(String resourceGroupName, String serverName, Context context) {
        PagedIterable<CapabilityInner> inner = this.serviceClient().list(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CapabilityImpl((CapabilityInner)inner1, this.manager()));
    }

    private CapabilitiesByServersClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

